/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class ProjectUtils {
    private static final String RSE_INTERNAL_PROJECTS = "RemoteSystems";
    private static final String EXTERNAL_PLUGIN_LIBRARIES = "External Plug-in Libraries";

    public static boolean exists(IProject project) {
        return project != null && project.exists();
    }

    public static boolean exists(String name) {
        return ProjectUtils.exists(ResourcesPlugin.getWorkspace().getRoot().getProject(name));
    }

    public static IProject getProject(String name) {
        if (StringUtils.isEmptyOrNull(name)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return ProjectUtils.exists(project) ? project : null;
    }

    public static boolean isAccessible(IProject project) {
        return project != null && project.isAccessible();
    }

    public static List<IProject> getAllAccessibleProjects(boolean excludeInternalProjects) {
        return Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(project -> {
            if (ProjectUtils.isAccessible(project)) {
                if (!excludeInternalProjects) {
                    return true;
                }
                return !ProjectUtils.isInternalRSE(project.getName()) && !ProjectUtils.isInternalPde(project.getName());
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static String[] getAllAccessibleProjectNames() {
        return ProjectUtils.getAllAccessibleProjectNames(true);
    }

    public static String[] getAllAccessibleProjectNames(boolean excludeInternalProjects) {
        return (String[])ProjectUtils.getAllAccessibleProjects(excludeInternalProjects).stream().map(IResource::getName).toArray(String[]::new);
    }

    public static List<IProject> getAllAccessibleProjects() {
        return ProjectUtils.getAllAccessibleProjects(true);
    }

    public static boolean isInternalRSE(String projectName) {
        return projectName != null && projectName.startsWith(RSE_INTERNAL_PROJECTS);
    }

    public static boolean isInternalPde(String projectName) {
        return projectName != null && projectName.startsWith(EXTERNAL_PLUGIN_LIBRARIES);
    }

    public static String getName(IProject project) {
        if (ProjectUtils.isAccessible(project)) {
            return project.getName();
        }
        return null;
    }
}

