/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;

public class StringUtils {
    private static final String LINE_SEPARATOR_KEY = "line.separator";
    private static final String SHORTENING_MARKER = "...";

    public static String pluralize(String value) {
        return String.valueOf(value) + "s";
    }

    public static String null2emptyString(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }

    public static String toStringOrNull(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isEmpty(Object value) {
        return value instanceof String && StringUtils.isEmpty((String)value);
    }

    public static <T> String toString(List<T> elements) {
        return StringUtils.toString(elements, new ToStringConverter<T>(){

            @Override
            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                return String.valueOf(object);
            }
        });
    }

    public static <T> String toString(Collection<T> elements, ToStringConverter<T> converter) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (T element : elements) {
            builder.append(converter.toString(element));
            if (++i >= elements.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static <T> String toString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return StringUtils.toString(map.entrySet(), new ToStringConverter<Map.Entry<String, String>>(){

            @Override
            public String toString(Map.Entry<String, String> entry) {
                return entry.getKey() + '=' + entry.getValue();
            }
        });
    }

    public static String getLineSeparator() {
        return System.getProperty(LINE_SEPARATOR_KEY);
    }

    public static boolean isAlphaNumeric(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaNumericOrUnderscore(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != '_' && !Character.isLetterOrDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWithLetterOrUnderscore(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        char character = value.charAt(0);
        return character == '_' || Character.isLetter(character);
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.isEmpty();
    }

    public static String shorten(String text, int maxLength) {
        if (text.length() < maxLength) {
            return text;
        }
        int availableCharacters = maxLength - SHORTENING_MARKER.length();
        if (availableCharacters <= 0) {
            return SHORTENING_MARKER;
        }
        return text.substring(0, (availableCharacters + 1) / 2) + SHORTENING_MARKER + text.substring(text.length() - availableCharacters / 2, text.length());
    }

    public static String[] shorten(String[] parts, int maxLength) {
        if (parts == null || parts.length == 0) {
            return parts;
        }
        if (parts.length == 1) {
            parts[0] = StringUtils.shorten(parts[0], maxLength);
        } else if (parts.length == 2) {
            int length1;
            int length0 = StringUtils.isEmpty(parts[0]) ? 0 : parts[0].length();
            int n = length1 = StringUtils.isEmpty(parts[1]) ? 0 : parts[1].length();
            if (length0 + length1 > maxLength) {
                int partLimit = maxLength / 2;
                if (length1 <= partLimit) {
                    parts[0] = StringUtils.shorten(parts[0], maxLength - length1);
                } else if (length0 <= partLimit) {
                    parts[1] = StringUtils.shorten(parts[1], maxLength - length0);
                } else {
                    parts[0] = StringUtils.shorten(parts[0], partLimit);
                    parts[1] = StringUtils.shorten(parts[1], partLimit);
                }
            }
        } else {
            int[] lengths = new int[parts.length];
            int totalLength = 0;
            int i = 0;
            while (i < parts.length) {
                lengths[i] = StringUtils.isEmpty(parts[i]) ? 0 : parts[i].length();
                totalLength += lengths[i];
                ++i;
            }
            if (totalLength > maxLength) {
                int totalCut = totalLength - maxLength;
                int[] cuts = new int[parts.length];
                int currentCut = 0;
                int i2 = 0;
                while (i2 < parts.length) {
                    if (lengths[i2] >= SHORTENING_MARKER.length()) {
                        cuts[i2] = lengths[i2] * totalCut / totalLength;
                        currentCut += cuts[i2];
                    }
                    ++i2;
                }
                while (currentCut < totalCut) {
                    boolean changed = false;
                    int i3 = 0;
                    while (i3 < parts.length) {
                        if (lengths[i3] - cuts[i3] > SHORTENING_MARKER.length()) {
                            int n = i3;
                            cuts[n] = cuts[n] + 1;
                            if (++currentCut == totalCut) break;
                            changed = true;
                        }
                        ++i3;
                    }
                    if (!changed) break;
                }
                i2 = 0;
                while (i2 < parts.length) {
                    if (cuts[i2] > 0) {
                        parts[i2] = StringUtils.shorten(parts[i2], parts[i2].length() - cuts[i2]);
                    }
                    ++i2;
                }
            }
        }
        return parts;
    }

    public static String getWithoutSuffix(String string, String suffix) {
        String stringNoSuffix = string;
        int suffixIndex = string.indexOf(suffix);
        if (suffixIndex >= 0) {
            stringNoSuffix = string.substring(0, suffixIndex);
        }
        return stringNoSuffix;
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        return string.trim();
    }

    public static String toLowerCase(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        return string.toLowerCase();
    }

    public static boolean areEqual(String thisString, String thatString) {
        if (thisString == null) {
            return thatString == null;
        }
        return thisString.equals(thatString);
    }

    public static String humanize(String value) {
        Object[] parts = org.apache.commons.lang.StringUtils.splitByCharacterTypeCamelCase((String)value);
        String split = org.apache.commons.lang.StringUtils.join((Object[])parts, (String)" ");
        return WordUtils.capitalize((String)split);
    }

    public static String serialize(Map<String, String> map) {
        ArrayList<String> out = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            out.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        Collections.sort(out);
        return org.apache.commons.lang.StringUtils.join((Object[])out.toArray(), (String)",");
    }

    public static String removeTrailingSlashes(String value) {
        return StringUtils.removeAll("/*$", value);
    }

    public static String removeAll(String regex, String value) {
        if (StringUtils.isEmpty(value) || StringUtils.isEmpty(regex)) {
            return value;
        }
        return value.replaceAll(regex, "");
    }

    public static interface ToStringConverter<T> {
        public String toString(T var1);
    }
}

