/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.job;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class FireConnectionsChangedJob
extends AbstractDelegatingMonitorJob {
    protected List<IConnection> connections = new ArrayList<IConnection>();

    public FireConnectionsChangedJob(IConnection connection) {
        super(NLS.bind((String)"Refreshing connection {0}", (Object)connection.getHost()));
        this.add(connection);
    }

    protected FireConnectionsChangedJob(String jobName) {
        super(jobName);
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        for (IConnection connection : this.getConnections()) {
            ConnectionsRegistrySingleton.getInstance().fireConnectionChanged(connection);
        }
        return Status.OK_STATUS;
    }

    protected List<IConnection> getConnections() {
        return this.connections;
    }

    private void add(IConnection connection) {
        if (connection != null) {
            this.connections.add(connection);
        }
    }
}

