/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.openshift.internal.common.core.security.SecureStore;

public class OpenShiftSecureStorageKey
implements SecureStore.IStoreKey {
    private static final String SEPARATOR = "/";
    private static final Pattern SCHEME_PATTERN = Pattern.compile(".+://(.*)");
    private String baseKey;
    private String host;
    private String userName;

    public OpenShiftSecureStorageKey(String baseKey, String host, String userName) {
        this.baseKey = baseKey;
        this.host = this.sanitizeHost(host);
        this.userName = userName;
    }

    @Override
    public String getKey() {
        return this.baseKey + SEPARATOR + this.host + SEPARATOR + this.userName;
    }

    private String sanitizeHost(String value) {
        Matcher matcher = SCHEME_PATTERN.matcher(value);
        String host = matcher.find() && matcher.groupCount() == 1 ? matcher.group(1) : value;
        if (host.endsWith(SEPARATOR)) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public boolean equals(Object key) {
        if (!key.getClass().isAssignableFrom(OpenShiftSecureStorageKey.class)) {
            return false;
        }
        OpenShiftSecureStorageKey openshiftKey = (OpenShiftSecureStorageKey)key;
        return this.userName != null && openshiftKey.userName != null && this.userName.equals(openshiftKey.userName) && this.host != null && openshiftKey.host != null && this.host.equals(openshiftKey.host);
    }
}

