/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;
import org.jboss.tools.openshift.internal.common.core.util.ThreadUtils;

public class CommandLocationLookupStrategy {
    private static final String LINUX_WHICH = "which";
    private static final String WINDOWS_WHERE = "where";
    private static final String LINUX_PATHVAR = "PATH";
    private static final String WINDOWS_PATHVAR = "Path";
    private static final String LINUX_SEPARATOR = ":";
    private static final String WIN_SEPARATOR = ";";
    public static final CommandLocationLookupStrategy WINDOWS_STRATEGY = new CommandLocationLookupStrategy("where", ";", System.getenv().get("Path") == null ? "PATH" : "Path", new String[]{".exe", ".com"}, null);
    public static final CommandLocationLookupStrategy LINUX_STRATEGY = new CommandLocationLookupStrategy("which", ":", "PATH", new String[0], null);
    public static final CommandLocationLookupStrategy MAC_STRATEGY = new CommandLocationLookupStrategy("which", ":", "PATH", new String[0], new String[]{"bash", "-l", "-c", "echo $PATH"}, true);
    private String which;
    private String delim;
    private String pathvar;
    private String[] pathCommand;
    private String[] suffixes;
    private boolean preferSystemPath;

    public static CommandLocationLookupStrategy get() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return WINDOWS_STRATEGY;
        }
        if ("macosx".equals(os)) {
            return MAC_STRATEGY;
        }
        return LINUX_STRATEGY;
    }

    public CommandLocationLookupStrategy(String which, String delim, String pathvar, String[] suffixes, String[] pathCommand) {
        this(which, delim, pathvar, suffixes, pathCommand, false);
    }

    public CommandLocationLookupStrategy(String which, String delim, String pathvar, String[] suffixes, String[] pathCommand, boolean preferSystemPath) {
        this.which = which;
        this.delim = delim;
        this.pathvar = pathvar;
        this.suffixes = suffixes;
        this.pathCommand = pathCommand;
        this.preferSystemPath = preferSystemPath;
    }

    public String search(CommandLocationBinary binary) {
        return this.search(binary, 2000);
    }

    public String search(CommandLocationBinary binary, int timeout) {
        String cmd = binary.getCommand(Platform.getOS());
        String defaultLoc = binary.getDefaultLoc(Platform.getOS());
        return this.findLocation(defaultLoc, cmd, this.which, this.delim, this.pathvar, timeout);
    }

    private String findLocation(String defaultLoc, String cmd, String which, String delim, String pathvar, int timeout) {
        if (defaultLoc != null && new File(defaultLoc).exists()) {
            return defaultLoc;
        }
        String ret = this.searchPath(System.getenv(pathvar), delim, cmd);
        if (ret == null) {
            ret = this.runCommandAndVerify(new String[]{which, cmd}, timeout);
        }
        return ret;
    }

    public void ensureOnPath(Map<String, String> env, String folder) {
        HashMap<String, String> processEnv = new HashMap<String, String>(System.getenv());
        if (env.get(this.pathvar) == null) {
            if (this.preferSystemPath) {
                String pathresult = this.runCommand(this.pathCommand);
                processEnv.put(this.pathvar, pathresult);
            }
            String newPath = this.ensureFolderOnPath(processEnv.get(this.pathvar), folder);
            env.put(this.pathvar, newPath);
        } else {
            String newPath = this.ensureFolderOnPath(env.get(this.pathvar), folder);
            env.put(this.pathvar, newPath);
        }
    }

    private String ensureFolderOnPath(String existingPath, String folder) {
        String[] roots = (existingPath = existingPath == null ? "" : existingPath).split(this.delim);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(roots));
        if (!list.contains(folder)) {
            list.add(folder);
        }
        return String.join((CharSequence)this.delim, list);
    }

    private String[] getPossibleCommandNames(String commandName) {
        ArrayList<String> ret = new ArrayList<String>(5);
        ret.add(commandName);
        int i = 0;
        while (i < this.suffixes.length) {
            ret.add(String.valueOf(commandName) + this.suffixes[i]);
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String[] getSuffixes() {
        return this.suffixes == null ? new String[]{} : this.suffixes;
    }

    public String[] getPossibleCommandNames(CommandLocationBinary binary) {
        return this.getPossibleCommandNames(binary.getCommand(Platform.getOS()));
    }

    private String searchPath(String path, String delim, String commandName) {
        String[] roots = path.split(delim);
        String[] withSuffixes = this.getPossibleCommandNames(commandName);
        int i = 0;
        while (i < roots.length) {
            int j = 0;
            while (j < withSuffixes.length) {
                File test = new File(roots[i], withSuffixes[j]);
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private String runCommandAndVerify(final String[] cmd, int timeout) {
        if (timeout == -1) {
            return this.runCommandAndVerify(cmd);
        }
        String path = ThreadUtils.runWithTimeout(timeout, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return CommandLocationLookupStrategy.this.runCommandAndVerify(cmd);
            }
        });
        return path;
    }

    private String runCommandAndVerify(String[] cmd) {
        String result;
        Process p = this.createProcess(cmd, this.preferSystemPath);
        if (p != null && (result = this.readProcess(p)) != null && !result.isEmpty() && new File(result).exists()) {
            return result;
        }
        return null;
    }

    private String runCommand(String[] cmd) {
        Process p = this.createProcess(cmd);
        if (p != null) {
            String result = this.readProcess(p);
            return result;
        }
        return null;
    }

    private Process createProcess(String[] cmd) {
        try {
            return Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ioe) {
            OpenShiftCommonCoreActivator.log(ioe);
            return null;
        }
    }

    private Process createProcess(String[] cmd, boolean useSystemPath) {
        try {
            if (useSystemPath) {
                String pathresult = this.runCommand(this.pathCommand);
                ProcessBuilder pb = new ProcessBuilder(cmd);
                Map<String, String> env = pb.environment();
                env.put(this.pathvar, pathresult);
                return pb.start();
            }
            return Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ioe) {
            OpenShiftCommonCoreActivator.log(ioe);
            return null;
        }
    }

    private String readProcess(Process p) {
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        InputStream is = null;
        if (p.exitValue() == 0) {
            is = p.getInputStream();
        }
        if (is != null) {
            block15: {
                String string;
                try {
                    String cmdOutput;
                    Scanner s = new Scanner(is).useDelimiter("\\A");
                    String string2 = cmdOutput = s.hasNext() ? s.next() : "";
                    if (cmdOutput.isEmpty()) break block15;
                    string = cmdOutput = StringUtils.trim((String)cmdOutput);
                }
                catch (Throwable throwable) {
                    try {
                        if (p != null) {
                            p.destroy();
                        }
                        is.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (p != null) {
                        p.destroy();
                    }
                    is.close();
                }
                catch (IOException iOException) {}
                return string;
            }
            try {
                if (p != null) {
                    p.destroy();
                }
                is.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

