/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class KeyValueFilterFactory {
    private static final String GROUP_KEY = "KEY";
    private static final String GROUP_VALUE = "VALUE";
    private static final String KEY_VALUE_DELIMITER = "=";
    private static final Pattern filterPattern = Pattern.compile("(?<KEY>[^=]+)\\s*(=)?\\s*(?<VALUE>[^,]*)\\s*,*\\s*", 2);

    private KeyValueFilterFactory() {
    }

    public static List<KeyValueFilter> create(String expression) {
        return KeyValueFilterFactory.parse(expression);
    }

    private static List<KeyValueFilter> parse(String expression) {
        ArrayList<KeyValueFilter> filters = new ArrayList<KeyValueFilter>();
        Matcher matcher = filterPattern.matcher(expression);
        while (matcher.find()) {
            String expression1 = matcher.group(GROUP_KEY);
            String expression2 = matcher.group(GROUP_VALUE);
            boolean hasKeyValueDelimiter = StringUtils.equals((String)KEY_VALUE_DELIMITER, (String)matcher.group(2));
            filters.add(KeyValueFilterFactory.createLabelFilter(expression1, expression2, hasKeyValueDelimiter));
        }
        return filters;
    }

    private static KeyValueFilter createLabelFilter(String expression1, String expression2, boolean hasKeyValuedelimiter) {
        String keyExpression = null;
        String valueExpression = null;
        if (StringUtils.isEmpty((String)expression2) && !hasKeyValuedelimiter) {
            valueExpression = expression1;
        } else {
            keyExpression = expression1;
            valueExpression = expression2;
        }
        return new KeyValueFilter(keyExpression, valueExpression);
    }

    public static class KeyValueFilter {
        private Pattern keyPattern;
        private Pattern valuePattern;

        public KeyValueFilter() {
            this(null, null);
        }

        private KeyValueFilter(String keyRegex, String valueRegex) {
            if (!StringUtils.isEmpty((String)keyRegex)) {
                this.keyPattern = Pattern.compile(keyRegex);
            }
            if (!StringUtils.isEmpty((String)valueRegex)) {
                this.valuePattern = Pattern.compile(valueRegex);
            }
        }

        public boolean matchesKey(String toMatch) {
            if (this.keyPattern == null) {
                return true;
            }
            return this.keyPattern.matcher(toMatch).find();
        }

        public boolean matchesValue(String toMatch) {
            if (this.valuePattern == null) {
                return true;
            }
            return this.valuePattern.matcher(toMatch).find();
        }

        public Range getMatchingRangeForKey(String key) {
            return this.getMatchingRange(key, this.keyPattern);
        }

        public Range getMatchingRangeForValue(String value) {
            return this.getMatchingRange(value, this.valuePattern);
        }

        private Range getMatchingRange(String string, Pattern pattern) {
            Matcher matcher;
            Range range = null;
            if (pattern != null && (matcher = pattern.matcher(string)).find() && matcher.start() >= 0 && matcher.end() > 0) {
                range = new Range(matcher.start(), matcher.end() - matcher.start());
            }
            return range;
        }

        public String toString() {
            return "LabelFilter [keyPattern=" + this.keyPattern + ", valuePattern=" + this.valuePattern + "]";
        }

        public static class Range {
            public final int start;
            public final int length;

            public Range(int start, int length) {
                this.start = start;
                this.length = length;
            }
        }
    }
}

