/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.application.importoperation;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIMessages;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.AbstractProjectImportOperation;

public class GeneralProjectImportOperation
extends AbstractProjectImportOperation {
    public GeneralProjectImportOperation(File projectDirectory) {
        super(projectDirectory);
    }

    public List<IProject> importToWorkspace(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getProjectDirectory().getName());
        if (this.overwriteExistingProject(project, workspace, monitor)) {
            this.importToWorkspace(this.getProjectDirectory(), workspace, monitor);
        }
        return Collections.singletonList(project);
    }

    private void importToWorkspace(File projectDirectory, IWorkspace workspace, IProgressMonitor monitor) throws CoreException {
        String projectName = projectDirectory.getName();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocation(Path.fromOSString((String)projectDirectory.getAbsolutePath()));
        IProject project = workspace.getRoot().getProject(projectName);
        project.create(description, monitor);
        project.open(128, monitor);
    }

    private boolean overwriteExistingProject(IProject project, IWorkspace workspace, IProgressMonitor monitor) throws CoreException {
        if (project == null || !project.exists()) {
            return true;
        }
        boolean overwrite = this.displayOverwriteDialog(OpenShiftCommonUIMessages.OverwriteProjectsDialogTitle, NLS.bind((String)OpenShiftCommonUIMessages.GeneralProjectWarningMessage, (Object)project.getName()));
        if (overwrite) {
            project.delete(false, true, monitor);
        } else {
            project.refreshLocal(2, monitor);
        }
        return overwrite;
    }
}

