/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.connection;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPage;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.connection.IConnectionEditor;
import org.jboss.tools.openshift.internal.common.ui.detailviews.BaseDetailsView;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;

public abstract class BaseConnectionEditor
extends BaseDetailsView
implements IConnectionEditor {
    protected ConnectionWizardPage wizardPage;
    protected ConnectionWizardPageModel pageModel;
    protected IObservableValue<? extends IConnection> selectedConnection;
    protected IValueChangeListener changeListener;
    protected ConnectionWizardPageModel.IConnectionAuthenticationProvider connectionAuthenticationProvider;
    protected boolean visible;
    private IValueChangeListener connectionChangedListener;

    @Override
    public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
        this.wizardPage = (ConnectionWizardPage)((Object)context);
        this.pageModel = this.wizardPage.getModel();
        this.selectedConnection = BeanProperties.value((String)"selectedConnection").observe((Object)this.pageModel);
        this.changeListener = this.createDetailViewChangedListener(this.pageModel);
        this.connectionAuthenticationProvider = this.createConnectionAuthenticationProvider(this.pageModel);
        return this.createControls(parent, this.pageModel, dbc);
    }

    protected abstract ConnectionWizardPageModel.IConnectionAuthenticationProvider createConnectionAuthenticationProvider(ConnectionWizardPageModel var1);

    protected abstract Composite createControls(Composite var1, ConnectionWizardPageModel var2, DataBindingContext var3);

    @Override
    public void onVisible(IObservableValue detailViewModel, DataBindingContext dbc) {
        this.visible = true;
        this.pageModel.setConnectionAuthenticationProvider(this.connectionAuthenticationProvider);
        this.connectionChangedListener = this.addSelectedConnectionChangedListener(this.selectedConnection, dbc);
        this.onVisible(detailViewModel, this.pageModel, dbc);
    }

    protected abstract void onVisible(IObservableValue var1, ConnectionWizardPageModel var2, DataBindingContext var3);

    @Override
    public void onInVisible(IObservableValue detailViewModel, DataBindingContext dbc) {
        this.visible = false;
        this.pageModel.setConnectionAuthenticationProvider(null);
        this.removeConnectionChangedListener(this.connectionChangedListener, this.selectedConnection);
        this.connectionChangedListener = null;
        this.onInVisible(detailViewModel, this.pageModel, dbc);
    }

    protected abstract void onInVisible(IObservableValue var1, ConnectionWizardPageModel var2, DataBindingContext var3);

    protected abstract void onSelectedConnectionChanged(IObservableValue var1);

    private IValueChangeListener addSelectedConnectionChangedListener(final IObservableValue selectedConnection, final DataBindingContext dbc) {
        IValueChangeListener listener = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                BaseConnectionEditor.this.onSelectedConnectionChanged(selectedConnection);
                DataBindingUtils.validateTargetsToModels(dbc);
            }
        };
        selectedConnection.addValueChangeListener(listener);
        return listener;
    }

    private void removeConnectionChangedListener(IValueChangeListener connectionChangedListener, IObservableValue selectedConnection) {
        if (selectedConnection == null || selectedConnection.isDisposed() || connectionChangedListener == null) {
            return;
        }
        selectedConnection.removeValueChangeListener(connectionChangedListener);
    }

    protected IValueChangeListener createDetailViewChangedListener(final ConnectionWizardPageModel pageModel) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (!BaseConnectionEditor.this.visible) {
                    return;
                }
                pageModel.setNotConnected();
            }
        };
    }
}

