/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.databinding;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.dialog.ValidationMessageProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FormPresenterSupport {
    private IFormPresenter formPresenter;
    private DataBindingContext dbc;
    private IValidationMessageProvider messageProvider = new ValidationMessageProvider();
    private IObservableValue aggregateStatusProvider;
    private boolean uiChanged = false;
    private IChangeListener uiChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            FormPresenterSupport.this.handleUIChanged();
        }
    };
    private IListChangeListener validationStatusProvidersListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                Iterator it;
                ListDiffEntry listDiffEntry = differences[i];
                ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)listDiffEntry.getElement();
                IObservableList targets = validationStatusProvider.getTargets();
                if (listDiffEntry.isAddition()) {
                    targets.addListChangeListener(FormPresenterSupport.this.validationStatusProviderTargetsListener);
                    it = targets.iterator();
                    while (it.hasNext()) {
                        ((IObservable)it.next()).addChangeListener(FormPresenterSupport.this.uiChangeListener);
                    }
                } else {
                    targets.removeListChangeListener(FormPresenterSupport.this.validationStatusProviderTargetsListener);
                    it = targets.iterator();
                    while (it.hasNext()) {
                        ((IObservable)it.next()).removeChangeListener(FormPresenterSupport.this.uiChangeListener);
                    }
                }
                ++i;
            }
        }
    };
    private IListChangeListener validationStatusProviderTargetsListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry listDiffEntry = differences[i];
                IObservable target = (IObservable)listDiffEntry.getElement();
                if (listDiffEntry.isAddition()) {
                    target.addChangeListener(FormPresenterSupport.this.uiChangeListener);
                } else {
                    target.removeChangeListener(FormPresenterSupport.this.uiChangeListener);
                }
                ++i;
            }
        }
    };
    private ValidationStatusProvider currentStatusProvider;
    protected IStatus currentStatus;
    protected boolean currentStatusStale;

    public FormPresenterSupport(IFormPresenter formPresenter, DataBindingContext dbc) {
        this.formPresenter = formPresenter;
        this.dbc = dbc;
        this.init();
    }

    public void setValidationMessageProvider(IValidationMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        this.handleStatusChanged();
    }

    protected void init() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.aggregateStatusProvider = new MaxSeverityValidationStatusProvider(this.dbc);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        this.aggregateStatusProvider.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                FormPresenterSupport.this.statusProviderChanged();
            }
        });
        this.formPresenter.getControl().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                FormPresenterSupport.this.dispose();
            }
        });
        this.aggregateStatusProvider.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
                FormPresenterSupport.this.currentStatusStale = true;
                FormPresenterSupport.this.handleStatusChanged();
            }
        });
        this.statusProviderChanged();
        this.dbc.getValidationStatusProviders().addListChangeListener(this.validationStatusProvidersListener);
        for (ValidationStatusProvider validationStatusProvider : this.dbc.getValidationStatusProviders()) {
            IObservableList targets = validationStatusProvider.getTargets();
            targets.addListChangeListener(this.validationStatusProviderTargetsListener);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ((IObservable)iter.next()).addChangeListener(this.uiChangeListener);
            }
        }
    }

    private void statusProviderChanged() {
        this.currentStatusProvider = (ValidationStatusProvider)this.aggregateStatusProvider.getValue();
        this.currentStatus = this.currentStatusProvider != null ? (IStatus)this.currentStatusProvider.getValidationStatus().getValue() : null;
        this.currentStatusStale = this.aggregateStatusProvider.isStale();
        this.handleStatusChanged();
    }

    protected void handleUIChanged() {
        this.uiChanged = true;
        if (this.currentStatus != null) {
            this.handleStatusChanged();
        }
        this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        for (ValidationStatusProvider validationStatusProvider : this.dbc.getValidationStatusProviders()) {
            IObservableList targets = validationStatusProvider.getTargets();
            targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ((IObservable)iter.next()).removeChangeListener(this.uiChangeListener);
            }
        }
    }

    protected void handleStatusChanged() {
        this.handleMessage();
        this.handleComplete();
    }

    private void handleComplete() {
        boolean pageComplete = true;
        if (this.currentStatusStale) {
            pageComplete = false;
        } else if (this.currentStatus != null) {
            pageComplete = !this.currentStatus.matches(12);
        }
        this.formPresenter.setComplete(pageComplete);
    }

    private void handleMessage() {
        String message = this.messageProvider.getMessage(this.currentStatusProvider);
        int type = this.messageProvider.getMessageType(this.currentStatusProvider);
        if (type == 3) {
            this.formPresenter.setMessage(this.uiChanged ? message : null, 3);
            if (this.currentStatus != null && this.currentStatusHasException()) {
                this.handleStatusException();
            }
        } else {
            this.formPresenter.setMessage(message, type);
        }
    }

    private boolean currentStatusHasException() {
        boolean hasException = false;
        if (this.currentStatus.getException() != null) {
            hasException = true;
        }
        if (this.currentStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.currentStatus;
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (status.getException() != null) {
                    hasException = true;
                    break;
                }
                ++i;
            }
        }
        return hasException;
    }

    protected void handleStatusException() {
        if (this.currentStatus.getException() != null) {
            this.logThrowable(this.currentStatus.getException());
        } else if (this.currentStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.currentStatus;
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (status.getException() != null) {
                    this.logThrowable(status.getException());
                }
                ++i;
            }
        }
    }

    private void logThrowable(Throwable throwable) {
        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 0, "Unhandled exception: " + throwable.getMessage(), throwable));
    }

    public void dispose() {
        if (this.aggregateStatusProvider != null) {
            this.aggregateStatusProvider.dispose();
        }
        if (this.dbc != null && !this.uiChanged) {
            for (ValidationStatusProvider validationStatusProvider : this.dbc.getValidationStatusProviders()) {
                IObservableList targets = validationStatusProvider.getTargets();
                if (targets == null) continue;
                targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
                Iterator iter = targets.iterator();
                while (iter.hasNext()) {
                    ((IObservable)iter.next()).removeChangeListener(this.uiChangeListener);
                }
            }
            this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        }
        this.aggregateStatusProvider = null;
        this.dbc = null;
        this.uiChangeListener = null;
        this.validationStatusProvidersListener = null;
        this.validationStatusProviderTargetsListener = null;
        this.formPresenter = null;
    }

    public IStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public static interface IFormPresenter {
        public void setMessage(String var1, int var2);

        public void setComplete(boolean var1);

        public Control getControl();
    }

    class MaxSeverityValidationStatusProvider
    extends ComputedValue {
        private Collection validationStatusProviders;

        public MaxSeverityValidationStatusProvider(DataBindingContext dbc) {
            super(ValidationStatusProvider.class);
            this.validationStatusProviders = dbc.getValidationStatusProviders();
        }

        protected Object calculate() {
            int maxSeverity = 0;
            ValidationStatusProvider maxSeverityProvider = null;
            for (ValidationStatusProvider provider : this.validationStatusProviders) {
                IStatus status = (IStatus)provider.getValidationStatus().getValue();
                if (status.getSeverity() <= maxSeverity) continue;
                maxSeverity = status.getSeverity();
                maxSeverityProvider = provider;
            }
            return maxSeverityProvider;
        }

        public synchronized void dispose() {
            this.validationStatusProviders = null;
            super.dispose();
        }
    }
}

