/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class TableViewerBuilder {
    private TableViewer viewer;
    private TableColumnLayout tableLayout;
    Font normalFont;
    Font italicFont;

    public TableViewerBuilder(Table table, Composite tableContainer) {
        this(new TableViewer(table), tableContainer);
    }

    public TableViewerBuilder(TableViewer viewer, Composite tableContainer) {
        this.viewer = viewer;
        viewer.setComparer((IElementComparer)new EqualityComparer());
        this.tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)this.tableLayout);
        this.normalFont = viewer.getTable().getFont();
        FontData fd = this.normalFont.getFontData()[0];
        fd.setStyle(2);
        this.italicFont = new Font(null, fd);
        viewer.getTable().addDisposeListener(event -> this.italicFont.dispose());
    }

    public TableViewerBuilder contentProvider(IStructuredContentProvider contentProvider) {
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        return this;
    }

    public TableViewerBuilder comparer(IElementComparer sorter) {
        this.viewer.setComparer(sorter);
        return this;
    }

    public TableViewerBuilder sorter(ViewerComparator sorter) {
        this.viewer.setComparator(sorter);
        return this;
    }

    public <E> ColumnBuilder<E> column(String name) {
        return new ColumnBuilder().name(name);
    }

    public <E> ColumnBuilder<E> column(IColumnLabelProvider<E> columnLabelProvider) {
        return new ColumnBuilder<E>().labelProvider(columnLabelProvider);
    }

    public <E> ColumnBuilder<E> column(CellLabelProvider cellLabelProvider) {
        return new ColumnBuilder().labelProvider(cellLabelProvider);
    }

    public TableViewer buildViewer() {
        return this.viewer;
    }

    public void applyFont(ViewerCell cell, boolean italic) {
        cell.setFont(italic ? this.italicFont : this.normalFont);
    }

    public class ColumnBuilder<E> {
        private int alignement;
        private IColumnLabelProvider<E> columnLabelProvider;
        private CellLabelProvider cellLabelProvider;
        private ICellToolTipProvider<E> cellToolTipProvider;
        private String name;
        private int weight;
        private int minWidth = 20;

        private ColumnBuilder() {
        }

        public ColumnBuilder<E> labelProvider(IColumnLabelProvider<E> labelProvider) {
            this.columnLabelProvider = labelProvider;
            return this;
        }

        public ColumnBuilder<E> labelProvider(CellLabelProvider labelProvider) {
            this.cellLabelProvider = labelProvider;
            return this;
        }

        public ColumnBuilder<E> cellToolTipProvider(ICellToolTipProvider<E> cellToolTipProvider) {
            this.cellToolTipProvider = cellToolTipProvider;
            return this;
        }

        public ColumnBuilder<E> align(int alignement) {
            this.alignement = alignement;
            return this;
        }

        public ColumnBuilder<E> name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder<E> weight(int weight) {
            this.weight = weight;
            return this;
        }

        public ColumnBuilder<E> minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public TableViewerBuilder buildColumn() {
            if (this.cellToolTipProvider != null || this.cellLabelProvider instanceof IToolTipProvider) {
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)TableViewerBuilder.this.viewer, (int)2);
            }
            TableViewerColumn column = new TableViewerColumn(TableViewerBuilder.this.viewer, this.alignement);
            column.getColumn().setText(this.name);
            this.setLabelAndTooltipProviders(this.columnLabelProvider, this.cellLabelProvider, this.cellToolTipProvider, column);
            TableViewerBuilder.this.tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.weight, this.minWidth, true));
            return TableViewerBuilder.this;
        }

        private void setLabelAndTooltipProviders(final IColumnLabelProvider<E> labelProvider, CellLabelProvider cellLabelProvider, final ICellToolTipProvider<E> tooltipProvider, TableViewerColumn column) {
            Assert.isLegal((cellLabelProvider != null && tooltipProvider == null || cellLabelProvider == null ? 1 : 0) != 0, (String)"cannot use ITooltipProvider with CellLabelProvider");
            if (labelProvider != null) {
                column.setLabelProvider(new CellLabelProvider(){

                    public void update(ViewerCell cell) {
                        if (labelProvider != null) {
                            String cellValue = labelProvider.getValue(cell.getElement());
                            cell.setText(cellValue);
                            boolean italic = labelProvider.isModified(cell.getElement());
                            TableViewerBuilder.this.applyFont(cell, italic);
                        }
                    }

                    public String getToolTipText(Object object) {
                        if (tooltipProvider != null) {
                            return tooltipProvider.getToolTipText(object);
                        }
                        return super.getToolTipText(object);
                    }

                    public int getToolTipDisplayDelayTime(Object element) {
                        if (tooltipProvider != null) {
                            return tooltipProvider.getToolTipDisplayDelayTime(element);
                        }
                        return super.getToolTipDisplayDelayTime(element);
                    }
                });
            } else if (cellLabelProvider != null) {
                column.setLabelProvider(cellLabelProvider);
            }
        }
    }

    public static class EqualityComparer
    implements IElementComparer {
        public boolean equals(Object thisObject, Object thatObject) {
            if (thisObject == null) {
                return thatObject != null;
            }
            if (thatObject == null) {
                return false;
            }
            return thisObject.equals(thatObject);
        }

        public int hashCode(Object element) {
            return element.hashCode();
        }
    }

    public static interface ICellToolTipProvider<T> {
        public String getToolTipText(T var1);

        public int getToolTipDisplayDelayTime(T var1);
    }

    public static interface IColumnLabelProvider<E> {
        public String getValue(E var1);

        default public boolean isModified(E e) {
            return false;
        }
    }
}

