/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.js.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.jsdt.chromium.debug.core.util.MementoFormat;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;

public final class NodeDebuggerUtil {
    public static final String CHROMIUM_LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.wst.jsdt.chromium.debug.ui.LaunchType$StandaloneV8";
    public static final String LOCALHOST = "localhost";
    public static final String PACKAGE_JSON = "package.json";
    public static final List<String> PREDEFIENED_WRAPPERS = new ArrayList<String>(){
        {
            this.add("org.eclipse.wst.jsdt.chromium.debug.core.model.HardcodedSourceWrapProvider$NodeJsStandardEntry");
            this.add("org.eclipse.wst.jsdt.chromium.debug.core.model.HardcodedSourceWrapProvider$NodeJsWithDefinedEntry");
        }
    };

    private NodeDebuggerUtil() {
    }

    public static String encode(List<String> wrappers) {
        StringBuilder output = new StringBuilder();
        Collections.sort(wrappers);
        for (String wrapper : wrappers) {
            MementoFormat.encodeComponent((String)wrapper, (StringBuilder)output);
        }
        return output.toString();
    }

    public static boolean isNodeJsProject(IServer server) {
        IProject p = OpenShiftServerUtils.getDeployProject((IServerAttributes)server);
        return p != null && p.isAccessible() && NodeDebuggerUtil.hasPackageJson(p);
    }

    private static boolean hasPackageJson(IProject project) {
        return project.getFile(PACKAGE_JSON).isAccessible();
    }
}

