/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.comparators;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ProjectViewerComparator
extends ViewerComparator {
    private static final int LAST = 1;
    private static final String DEFAULT_PROJECT = "default";
    private static final String OPENSHIFT_PROJECT = "openshift";
    private ILabelProvider labelProvider;

    public ProjectViewerComparator() {
    }

    public ProjectViewerComparator(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public Comparator<ObservableTreeItem> asItemComparator() {
        return new Comparator<ObservableTreeItem>(){

            @Override
            public int compare(ObservableTreeItem o1, ObservableTreeItem o2) {
                Object m1 = o1.getModel();
                Object m2 = o2.getModel();
                return ProjectViewerComparator.this.compare(null, m1, m2);
            }
        };
    }

    public Comparator<IProject> asProjectComparator() {
        return new Comparator<IProject>(){

            @Override
            public int compare(IProject o1, IProject o2) {
                return ProjectViewerComparator.this.compare(null, o1, o2);
            }
        };
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        boolean isProject1 = e1 instanceof IProject;
        boolean isProject2 = e2 instanceof IProject;
        if (!isProject1 || !isProject2) {
            return isProject1 ? -1 : (isProject2 ? 1 : 0);
        }
        IProject projectOne = (IProject)e1;
        IProject projectTwo = (IProject)e2;
        String name1 = projectOne.getName();
        String name2 = projectTwo.getName();
        if (DEFAULT_PROJECT.equals(name1)) {
            return -1;
        }
        if (DEFAULT_PROJECT.equals(name2)) {
            return 1;
        }
        if (name1.startsWith(OPENSHIFT_PROJECT) && !name2.startsWith(OPENSHIFT_PROJECT)) {
            return -1;
        }
        if (!name1.startsWith(OPENSHIFT_PROJECT) && name2.startsWith(OPENSHIFT_PROJECT)) {
            return 1;
        }
        if (this.labelProvider != null) {
            return this.labelProvider.getText(e1).compareTo(this.labelProvider.getText(e2));
        }
        return name1.compareTo(name2);
    }

    public static ViewerComparator createProjectTreeSorter() {
        return ProjectViewerComparator.createProjectTreeSorter(null);
    }

    public static ViewerComparator createProjectTreeSorter(final ILabelProvider labelProvider) {
        final ProjectViewerComparator projectComparator = new ProjectViewerComparator(labelProvider);
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ObservableTreeItem && e2 instanceof ObservableTreeItem) {
                    Object o1 = ((ObservableTreeItem)((Object)e1)).getModel();
                    Object o2 = ((ObservableTreeItem)((Object)e2)).getModel();
                    if (o1 instanceof IProject && o2 instanceof IProject) {
                        return projectComparator.compare(viewer, o1, o2);
                    }
                    if (labelProvider != null) {
                        return labelProvider.getText(o1).compareTo(labelProvider.getText(o2));
                    }
                    if (o1 instanceof IResource && o2 instanceof IResource) {
                        String name1 = ((IResource)o1).getName();
                        String name2 = ((IResource)o2).getName();
                        return this.getComparator().compare(name1, name2);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }
}

