/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IResource;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;
import org.jboss.tools.openshift.internal.ui.job.OpenShiftJobs;
import org.jboss.tools.openshift.internal.ui.models.IProjectWrapper;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;

public class DeleteResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IResourceWrapper[] resources = (IResourceWrapper[])UIUtils.getElements((ISelection)selection, IResourceWrapper.class);
        if (resources == null || resources.length == 0) {
            return OpenShiftUIActivator.statusFactory().cancelStatus("No resource selected that we can delete.");
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<IResourceWrapper> stream = Arrays.stream(resources);){
            boolean hasProject = stream.anyMatch(resource -> resource instanceof IProjectWrapper);
            String title = this.getDialogTitle(hasProject);
            String message = this.getDialogMessage(resources, hasProject);
            boolean confirm = MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)message);
            if (confirm) {
                this.deleteResources(resources);
            }
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getDialogTitle(boolean hasProject) {
        return hasProject ? OpenShiftUIMessages.ProjectDeletionDialogTitle : OpenShiftUIMessages.ResourceDeletionDialogTitle;
    }

    private String getDialogMessage(IResourceWrapper<?, ?>[] resources, boolean hasProject) {
        if (resources.length > 1) {
            if (hasProject) {
                return OpenShiftUIMessages.ProjectDeletionConfirmationN;
            }
            return OpenShiftUIMessages.ResourceDeletionConfirmationN;
        }
        IResource resource = (IResource)resources[0].getWrapped();
        if (hasProject) {
            return NLS.bind((String)OpenShiftUIMessages.ProjectDeletionConfirmation, (Object)resource.getName());
        }
        return NLS.bind((String)OpenShiftUIMessages.ResourceDeletionConfirmation, (Object)resource.getName(), (Object)resource.getKind());
    }

    protected void deleteResources(IResourceWrapper<?, ?>[] uiResources) {
        JobGroup group = new JobGroup("Deleting OpenShift resources...", 1, uiResources.length){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return false;
            }
        };
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<IResourceWrapper<?, ?>> stream = Arrays.stream(uiResources);){
            stream.forEach(uiResource -> {
                DeleteResourceJob job = OpenShiftJobs.createDeleteResourceJob((IResource)uiResource.getWrapped());
                job.setJobGroup(group);
                job.schedule();
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

