/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariablePage;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariablesPageModel;

class ManageEnvironmentVariablesWizard
extends Wizard {
    EnvironmentVariablesPageModel model = new EnvironmentVariablesPageModel();
    IReplicationController dc;

    public ManageEnvironmentVariablesWizard(IReplicationController dc) {
        this.dc = dc;
        List<EnvironmentVariable> vars = dc.getEnvironmentVariables().stream().map(var -> new EnvironmentVariable(var.getName(), var.getValue())).collect(Collectors.toList());
        this.model.setEnvironmentVariables(vars);
        this.setWindowTitle("Manage Environment Variables");
    }

    public boolean performFinish() {
        new Job("Updating environment variables for deployment config " + this.dc.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List<EnvironmentVariable> vars = ManageEnvironmentVariablesWizard.this.model.getEnvironmentVariables();
                    boolean modified = false;
                    for (EnvironmentVariable var : vars) {
                        if (!ManageEnvironmentVariablesWizard.this.model.isEnvironmentVariableModified(var)) continue;
                        modified = true;
                        String value = var.getValue();
                        if ("&Deleted".equals(value)) {
                            ManageEnvironmentVariablesWizard.this.dc.removeEnvironmentVariable(var.getKey());
                            continue;
                        }
                        ManageEnvironmentVariablesWizard.this.dc.setEnvironmentVariable(var.getKey(), var.getValue());
                    }
                    if (modified) {
                        Connection conn = ConnectionsRegistryUtil.getConnectionFor((IResource)ManageEnvironmentVariablesWizard.this.dc);
                        conn.updateResource((IResource)ManageEnvironmentVariablesWizard.this.dc);
                    }
                }
                catch (Exception e) {
                    String message = "Unable to update environment variables for deployment config " + ManageEnvironmentVariablesWizard.this.dc.getName();
                    OpenShiftUIActivator.getDefault().getLogger().logError(message, (Throwable)e);
                    return new Status(4, "org.jboss.tools.openshift.ui", message, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return true;
    }

    public void addPages() {
        EnvironmentVariablePageImpl page = new EnvironmentVariablePageImpl();
        this.addPage((IWizardPage)page);
    }

    class EnvironmentVariablePageImpl
    extends EnvironmentVariablePage {
        public EnvironmentVariablePageImpl() {
            super("Environment Variables", "Edit environment variables of deployment config " + ManageEnvironmentVariablesWizard.this.dc.getName(), "EnvVars", (IWizard)ManageEnvironmentVariablesWizard.this, ManageEnvironmentVariablesWizard.this.model);
            this.canDeleteAnyVar = true;
        }

        protected void doCreateControls(Composite parent, DataBindingContext dbc) {
            GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
            this.createEnvVariableControl(parent, dbc);
        }
    }
}

