/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IService;
import java.util.HashMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.internal.ui.models.IOpenshiftUIElement;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IRunningPodHolder;
import org.jboss.tools.openshift.internal.ui.utils.ResourceWrapperUtils;

public class ScaleDeploymentContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    static final String COMMAND_ID = "org.jboss.tools.openshift.ui.command.deployment.scale";
    static final String DYNAMIC_ITEM_ID = "org.jboss.tools.openshift.ui.command.deployment.dynamic.scale";
    private IServiceLocator fServiceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    public boolean isVisible() {
        return this.isRelevant();
    }

    public void fill(Menu menu, int index) {
        if (!this.isRelevant()) {
            return;
        }
        Menu m = new Menu(menu);
        super.fill(m, 0);
        MenuItem item = new MenuItem(menu, 64);
        item.setMenu(m);
        item.setText("Scale");
    }

    private boolean isRelevant() {
        ISelection selection;
        ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection iSelection = selection = service != null ? service.getSelection() : null;
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        IRunningPodHolder podHolder = (IRunningPodHolder)UIUtils.getFirstElement((ISelection)selection, IRunningPodHolder.class);
        if (podHolder == null) {
            return false;
        }
        IOpenshiftUIElement<?, IOpenshiftUIElement<?, ?>> podUIElement = podHolder.getPodUIElement();
        if (!(podUIElement instanceof IResourceWrapper)) {
            return false;
        }
        IResourceWrapper podWrapper = (IResourceWrapper)podUIElement;
        return ResourceWrapperUtils.getServiceWrapperFor(podWrapper, serviceWrapper -> ResourceUtils.areRelated((IPod)((IPod)podWrapper.getWrapped()), (IService)((IService)serviceWrapper.getWrapped()))) != null;
    }

    protected IContributionItem[] getContributionItems() {
        if (!this.isRelevant()) {
            return new IContributionItem[0];
        }
        HashMap<String, String> mapUp = new HashMap<String, String>();
        mapUp.put("org.jboss.tools.openshift.ui.command.deployment.scale.replicadiff", "1");
        CommandContributionItemParameter pUp = new CommandContributionItemParameter(this.fServiceLocator, "org.jboss.tools.openshift.ui.command.deployment.dynamic.scale.up", COMMAND_ID, mapUp, OpenShiftImages.TREND_UP, null, null, "Up", null, "Increment the number of deployed replicas by one.", 0, null, true);
        HashMap<String, String> mapDown = new HashMap<String, String>();
        mapDown.put("org.jboss.tools.openshift.ui.command.deployment.scale.replicadiff", "-1");
        CommandContributionItemParameter pDown = new CommandContributionItemParameter(this.fServiceLocator, "org.jboss.tools.openshift.ui.command.deployment.dynamic.scale.down", COMMAND_ID, mapDown, OpenShiftImages.TREND_DOWN, null, null, "Down", null, "Increment the number of deployed replicas by one.", 0, null, true);
        CommandContributionItemParameter pTo = new CommandContributionItemParameter(this.fServiceLocator, "org.jboss.tools.openshift.ui.command.deployment.dynamic.scale.to", COMMAND_ID, new HashMap(), null, null, null, "To...", null, "Scale the number of deployed replicas to a specific value.", 0, null, true);
        return new IContributionItem[]{new CommandContributionItem(pUp), new CommandContributionItem(pDown), new CommandContributionItem(pTo)};
    }
}

