/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.api.capabilities.IScalable;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.databinding.FormPresenterSupport;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;
import org.jboss.tools.openshift.internal.ui.utils.ResourceWrapperUtils;

public class ScaleDeploymentHandler
extends AbstractHandler {
    public static final String REPLICA_DIFF = "org.jboss.tools.openshift.ui.command.deployment.scale.replicadiff";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDeploymentConfig dc = this.getDeploymentConfig(this.getSelectedElement(event, IResourceWrapper.class));
        if (dc == null) {
            IResource resource = ResourceWrapperUtils.getResource(UIUtils.getFirstElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)));
            return OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not scale {0}: Could not find deployment config", (Object)(resource == null ? "" : resource.getName())));
        }
        this.scaleUsing(event, (IReplicationController)dc, dc.getName());
        return null;
    }

    protected <T> T getSelectedElement(ExecutionEvent event, Class<T> klass) {
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        return (T)UIUtils.getFirstElement((ISelection)selection, klass);
    }

    private IDeploymentConfig getDeploymentConfig(IResourceWrapper<?, ?> wrapper) {
        if (wrapper == null) {
            return null;
        }
        IDeploymentConfig dc = null;
        IResource wrapped = (IResource)wrapper.getWrapped();
        if (wrapper instanceof IServiceWrapper) {
            dc = this.getDeploymentConfig((IServiceWrapper)wrapper);
        } else if (wrapped instanceof IPod) {
            dc = this.getDeploymentConfig((IPod)wrapped, wrapper);
        } else if (wrapped instanceof IDeploymentConfig) {
            dc = (IDeploymentConfig)wrapped;
        } else if (wrapped instanceof IReplicationController) {
            dc = this.getDeploymentConfig((IReplicationController)wrapped, wrapper);
        }
        return dc;
    }

    private IDeploymentConfig getDeploymentConfig(IReplicationController rc, IResourceWrapper<?, ?> wrapper) {
        IDeploymentConfig dc = null;
        IServiceWrapper service = ResourceWrapperUtils.getServiceWrapperFor(wrapper, serviceWrapper -> ResourceUtils.areRelated((IReplicationController)rc, (IService)((IService)serviceWrapper.getWrapped())));
        if (service != null) {
            dc = ResourceUtils.getDeploymentConfigFor((IReplicationController)rc, ResourceWrapperUtils.getResources(service.getResourcesOfKind("DeploymentConfig")));
        }
        return dc;
    }

    private IDeploymentConfig getDeploymentConfig(IPod pod, IResourceWrapper<?, ?> wrapper) {
        IDeploymentConfig dc = null;
        if (!ResourceUtils.isBuildPod((IPod)pod)) {
            IServiceWrapper service = ResourceWrapperUtils.getServiceWrapperFor(wrapper, serviceWrapper -> ResourceUtils.areRelated((IPod)pod, (IService)((IService)serviceWrapper.getWrapped())));
            dc = this.getDeploymentConfig(service);
        }
        return dc;
    }

    private IDeploymentConfig getDeploymentConfig(IServiceWrapper service) {
        return (IDeploymentConfig)ResourceUtils.getLatestResourceVersion(service.getResourcesOfKind("DeploymentConfig").stream().map(wrapper -> (IDeploymentConfig)wrapper.getWrapped()).collect(Collectors.toList()));
    }

    protected void scaleUsing(ExecutionEvent event, IReplicationController rc, String name) {
        int requestedReplicas = this.getRequestedReplicas(rc, name, event);
        int currentReplicas = rc.getCurrentReplicaCount();
        if (requestedReplicas != -1 && currentReplicas != requestedReplicas) {
            if (requestedReplicas == 0 && !this.showStopDeploymentWarning(name, HandlerUtil.getActiveShell((ExecutionEvent)event))) {
                return;
            }
            this.scaleDeployment(event, name, rc, requestedReplicas);
        }
    }

    protected boolean showStopDeploymentWarning(String name, Shell shell) {
        MessageDialog dialog = new MessageDialog(shell, "Stop all deployments?", OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_ICON_IMG, NLS.bind((String)"Are you sure you want to scale {0} to 0 replicas?\nThis will stop all pods for the deployment.", (Object)name), 4, 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
        return dialog.open() == 0;
    }

    protected void scaleDeployment(ExecutionEvent event, final String name, final IReplicationController rc, final int replicas) {
        if (replicas >= 0) {
            new Job(NLS.bind((String)"Scaling {0} deployment to {1}...", (Object)name, (Object)replicas)){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        return (IStatus)rc.accept((CapabilityVisitor)new CapabilityVisitor<IScalable, IStatus>(){

                            public IStatus visit(IScalable capability) {
                                capability.scaleTo(replicas);
                                return Status.OK_STATUS;
                            }
                        }, (Object)new Status(4, "org.jboss.tools.openshift.ui", "Scaling is not supported for this resource"));
                    }
                    catch (Exception e) {
                        String message = NLS.bind((String)"Unable to scale {0}", (Object)name);
                        OpenShiftUIActivator.getDefault().getLogger().logError(message, (Throwable)e);
                        return new Status(4, "org.jboss.tools.openshift.ui", message, (Throwable)e);
                    }
                }
            }.schedule();
        }
    }

    private int getRequestedReplicas(IReplicationController rc, String name, ExecutionEvent event) {
        String diff = event.getParameter(REPLICA_DIFF);
        int currentReplicas = rc.getCurrentReplicaCount();
        if (NumberUtils.isNumber((String)diff)) {
            return currentReplicas + Integer.parseInt(diff);
        }
        return this.showScaleReplicasDialog(name, currentReplicas, HandlerUtil.getActiveShell((ExecutionEvent)event));
    }

    protected int showScaleReplicasDialog(String name, int currentReplicas, Shell shell) {
        ScaleReplicasDialog dialog = new ScaleReplicasDialog(currentReplicas, name, shell);
        if (dialog.open() == 0) {
            return dialog.getRequestedReplicas();
        }
        return -1;
    }

    public class ScaleReplicasDialog
    extends TitleAreaDialog {
        private int currentReplicas;
        private IObservableValue<Integer> requestedReplicas;
        private String name;

        public ScaleReplicasDialog(int currentReplicas, String name, Shell parentShell) {
            super(parentShell);
            this.currentReplicas = currentReplicas;
            this.requestedReplicas = new WritableValue((Object)currentReplicas, Integer.class);
            this.name = name;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.setupDialog(this.name, parent.getShell());
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            DataBindingContext dbc = new DataBindingContext();
            Label titleSeparator = new Label(parent, 258);
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)titleSeparator);
            final Composite dialogArea = new Composite(parent, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 20).spacing(20, -1).applyTo(dialogArea);
            Label scaleLabel = new Label(dialogArea, 0);
            scaleLabel.setText("Scale to number of replicas:");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)scaleLabel);
            Spinner scaleSpinner = new Spinner(dialogArea, 2048);
            scaleSpinner.setMinimum(0);
            scaleSpinner.setSelection(this.currentReplicas);
            scaleSpinner.setPageIncrement(1);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)scaleSpinner);
            ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)scaleSpinner)).validatingAfterConvert(new IValidator(){

                public IStatus validate(Object value) {
                    if (!(value instanceof Integer)) {
                        return ValidationStatus.error((String)NLS.bind((String)"You need to provide a positive number of replicas for deployment {0}", (Object)ScaleReplicasDialog.this.name));
                    }
                    int requestedReplicas = (Integer)value;
                    if (requestedReplicas == ScaleReplicasDialog.this.currentReplicas) {
                        return ValidationStatus.cancel((String)"");
                    }
                    if (requestedReplicas == 0) {
                        return ValidationStatus.warning((String)NLS.bind((String)"Scaling to 0 replicas will stop all pods.", (Object)ScaleReplicasDialog.this.name));
                    }
                    return ValidationStatus.ok();
                }
            })).to(this.requestedReplicas).in(dbc);
            new FormPresenterSupport(new FormPresenterSupport.IFormPresenter(){

                public void setMessage(String message, int type) {
                    ScaleReplicasDialog.this.setMessage(message, type);
                }

                public void setComplete(boolean complete) {
                    Button button = ScaleReplicasDialog.this.getButton(0);
                    if (!DisposeUtils.isDisposed((Control)button)) {
                        button.setEnabled(complete);
                    }
                }

                public Control getControl() {
                    return dialogArea;
                }
            }, dbc);
            return dialogArea;
        }

        private void setupDialog(String name, Shell shell) {
            shell.setText("Scale Deployments");
            this.setTitle(NLS.bind((String)"Enter the desired number of replicas for deployment {0}", (Object)name));
            this.setTitleImage(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM_IMG);
            this.setHelpAvailable(false);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            okButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        public int getRequestedReplicas() {
            if (this.getReturnCode() == 0) {
                return (Integer)this.requestedReplicas.getValue();
            }
            return -1;
        }
    }
}

