/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.util.OpenShiftResourceUniqueId;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsWizard;

public class ServerAdapterHandler
extends AbstractHandler {
    private static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IResource selectedResource = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
        IServer openShiftServer = this.getOpenShiftServer(selectedResource);
        if (openShiftServer != null) {
            this.openServersView(openShiftServer, workbenchWindow);
        }
        return null;
    }

    private IServer getOpenShiftServer(IResource resource) {
        if (resource == null) {
            return null;
        }
        Object source = null;
        IRoute route = null;
        if (resource instanceof IService) {
            source = (IService)resource;
        } else if (resource instanceof IRoute) {
            IRoute localRoute = route = (IRoute)resource;
            source = (IService)route.getProject().getResources("Service").stream().filter(s -> ResourceUtils.areRelated((IRoute)localRoute, (IService)((IService)s))).findFirst().orElseGet(() -> null);
        } else if (resource instanceof IReplicationController) {
            source = resource;
        } else if (resource instanceof IPod) {
            Collection services = ResourceUtils.getServicesFor((IPod)((IPod)resource), (Collection)resource.getProject().getResources("Service"));
            source = !services.isEmpty() ? (IResource)services.iterator().next() : ResourceUtils.getDeploymentConfigOrReplicationControllerFor((IPod)((IPod)resource));
        }
        if (source != null) {
            Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)source);
            return this.openOrCreateServerAdapter((IResource)source, route, connection);
        }
        return null;
    }

    private IServer openOrCreateServerAdapter(IResource resource, IRoute route, Connection connection) {
        if (resource == null || connection == null) {
            return null;
        }
        String resourceName = OpenShiftResourceUniqueId.get((IResource)resource);
        IServer server = OpenShiftServerUtils.findServerForResource((String)resourceName);
        if (server == null) {
            server = this.createServer(resourceName, resource, route, connection);
        }
        return server;
    }

    private IServer createServer(String resourceName, IResource resource, IRoute route, Connection connection) {
        IServer server = null;
        try {
            IServerWorkingCopy serverWorkingCopy = OpenShiftServerUtils.create((String)resourceName);
            ServerSettingsWizard serverSettingsWizard = new ServerSettingsWizard(serverWorkingCopy, connection, resource, route);
            if (WizardUtils.openWizardDialog((int)600, (int)650, (IWizard)serverSettingsWizard, (Shell)Display.getDefault().getActiveShell())) {
                server = serverSettingsWizard.getCreatedServer();
            }
        }
        catch (CoreException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError(NLS.bind((String)"Failed to create OpenShift Server Adapter for resource {0}", (Object)resourceName), (Throwable)e);
        }
        return server;
    }

    private void openServersView(IServer openShiftServer, IWorkbenchWindow workbenchWindow) {
        try {
            CommonNavigator serversViewPart = (CommonNavigator)workbenchWindow.getActivePage().showView(SERVERS_VIEW_ID);
            serversViewPart.setFocus();
            serversViewPart.getCommonViewer().refresh();
            serversViewPart.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)openShiftServer));
        }
        catch (PartInitException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError("Failed to open Servers View", (Throwable)e);
        }
    }
}

