/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.preferences;

import java.io.File;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;
import org.jboss.tools.openshift.internal.core.preferences.OCBinaryVersionValidator;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.osgi.framework.Version;

public class OpenShiftPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private CliFileEditor cliLocationEditor;
    private OCBinary ocBinary = OCBinary.getInstance();
    private Label ocVersionLabel;
    private Composite ocMessageComposite;
    private Label ocMessageLabel;
    private UIUpdatingJob versionVerificationJob;

    public OpenShiftPreferencePage() {
        super(1);
    }

    public void createFieldEditors() {
        Link link = new Link(this.getFieldEditorParent(), 64);
        link.setText("The OpenShift client binary (oc) is required for features such as Port Forwarding or Log Streaming. You can find more information about how to install it from <a>here</a>.");
        GridDataFactory.fillDefaults().span(3, 1).hint(1, 60).grab(true, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserUtility().checkedCreateExternalBrowser("https://github.com/openshift/origin/blob/master/CONTRIBUTING.adoc#download-from-github", "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
            }
        });
        this.cliLocationEditor = new CliFileEditor();
        this.cliLocationEditor.setFilterPath(SystemUtils.getUserHome());
        String[] suffixes = this.ocBinary.getExtensions();
        String[] filters = new String[suffixes.length];
        int i = 0;
        while (i < filters.length) {
            filters[i] = "*" + suffixes[i];
            ++i;
        }
        this.cliLocationEditor.setFileExtensions(filters);
        this.cliLocationEditor.setValidateStrategy(0);
        this.addField((FieldEditor)this.cliLocationEditor);
        this.ocVersionLabel = new Label(this.getFieldEditorParent(), 64);
        this.ocVersionLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.ocVersionLabel);
        this.ocMessageComposite = new Composite(this.getFieldEditorParent(), 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.ocMessageComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.ocMessageComposite);
        Label label = new Label(this.ocMessageComposite, 0);
        label.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)label);
        this.ocMessageLabel = new Label(this.ocMessageComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.ocMessageLabel);
        this.ocMessageComposite.setVisible(false);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(OpenShiftUIActivator.getDefault().getCorePreferenceStore());
    }

    protected void performDefaults() {
        String location = this.ocBinary.getSystemPathLocation();
        if (location == null) {
            location = "";
        }
        this.getPreferenceStore().setDefault("openshift.cli.location", location);
        if (StringUtils.isBlank((String)location)) {
            String message = NLS.bind((String)"Could not find the OpenShift client executable \"{0}\" on your path.", (Object)this.ocBinary.getName());
            OpenShiftUIActivator.getDefault().getLogger().logWarning(message);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"No OpenShift client executable", (String)message);
            return;
        }
        super.performDefaults();
        this.getPreferenceStore().setToDefault("openshift.cli.location");
    }

    public boolean performOk() {
        boolean valid = true;
        if (this.cliLocationEditor.getStringValue().equals(this.getPreferenceStore().getDefaultString("openshift.cli.location"))) {
            this.getPreferenceStore().setToDefault("openshift.cli.location");
        } else {
            valid = super.performOk();
        }
        valid = this.validateLocation(this.cliLocationEditor.getStringValue()) && valid;
        this.setValid(valid);
        return valid;
    }

    private boolean validateLocation(final String location) {
        if (StringUtils.isBlank((String)location)) {
            return true;
        }
        File file = new File(location);
        if (!file.exists()) {
            this.cliLocationEditor.setErrorMessage(NLS.bind((String)"{0} was not found.", (Object)file));
            return false;
        }
        if (!file.canExecute()) {
            this.cliLocationEditor.setErrorMessage(NLS.bind((String)"{0} does not have execute permissions.", (Object)file));
            return false;
        }
        this.setValid(false);
        this.ocVersionLabel.setText("Checking OpenShift client version...");
        this.versionVerificationJob = new UIUpdatingJob("Checking oc binary..."){
            private Version version;

            protected IStatus run(IProgressMonitor monitor) {
                this.version = new OCBinaryVersionValidator(location).getVersion(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            protected IStatus updateUI(IProgressMonitor monitor) {
                if (!this.getResult().isOK()) {
                    return this.getResult();
                }
                if (!OpenShiftPreferencePage.this.ocMessageComposite.isDisposed() && !monitor.isCanceled()) {
                    OpenShiftPreferencePage.this.setValid(true);
                    if (Version.emptyVersion.equals((Object)this.version)) {
                        OpenShiftPreferencePage.this.ocVersionLabel.setText("Could not determine your OpenShift client version");
                    } else {
                        OpenShiftPreferencePage.this.ocVersionLabel.setText(NLS.bind((String)"Your OpenShift client version is {0}.{1}.{2}", (Object[])new Object[]{this.version.getMajor(), this.version.getMinor(), this.version.getMicro()}));
                    }
                    OpenShiftPreferencePage.this.ocMessageLabel.setText(NLS.bind((String)"OpenShift client version 1.1.1 or higher is required to avoid rsync issues.", (Object)this.version));
                    OpenShiftPreferencePage.this.ocMessageComposite.setVisible(!OCBinaryVersionValidator.isCompatibleForPublishing((Version)this.version));
                }
                return super.updateUI(monitor);
            }
        };
        this.versionVerificationJob.schedule();
        return true;
    }

    class CliFileEditor
    extends FileFieldEditor {
        private String lastCheckedValue;

        public CliFileEditor() {
            super("openshift.cli.location", NLS.bind((String)"''{0}'' executable location", (Object)OpenShiftPreferencePage.this.ocBinary.getName()), false, 0, OpenShiftPreferencePage.this.getFieldEditorParent());
            this.lastCheckedValue = null;
        }

        protected boolean checkState() {
            boolean state;
            String newCheckedValue = this.getStringValue();
            if (!Objects.equals(newCheckedValue, this.lastCheckedValue)) {
                this.setErrorMessage(JFaceResources.getString((String)"FileFieldEditor.errorMessage"));
                OpenShiftPreferencePage.this.ocVersionLabel.setText("");
                OpenShiftPreferencePage.this.ocMessageComposite.setVisible(false);
                if (OpenShiftPreferencePage.this.versionVerificationJob != null) {
                    OpenShiftPreferencePage.this.versionVerificationJob.cancel();
                }
            }
            if (!(state = super.checkState())) {
                this.lastCheckedValue = newCheckedValue;
            }
            return state;
        }

        public boolean doCheckState() {
            String newCheckedValue = this.getStringValue();
            boolean state = true;
            if (!Objects.equals(newCheckedValue, this.lastCheckedValue)) {
                state = OpenShiftPreferencePage.this.validateLocation(newCheckedValue);
            }
            this.lastCheckedValue = this.getStringValue();
            return state;
        }
    }
}

