/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IEvent;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import com.openshift.restclient.model.volume.IPersistentVolumeClaim;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.property.BuildConfigPropertySource;
import org.jboss.tools.openshift.internal.ui.property.BuildPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ConnectionPropertySource;
import org.jboss.tools.openshift.internal.ui.property.EventPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ImageStreamPropertySource;
import org.jboss.tools.openshift.internal.ui.property.PodPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ReplicationControllerPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.RoutePropertySource;
import org.jboss.tools.openshift.internal.ui.property.ServicePropertySource;
import org.jboss.tools.openshift.internal.ui.property.StoragePropertySource;

public class OpenShiftPropertySourceAdapterFactory
implements IAdapterFactory {
    ConnectionPropertySource currentConnectionPropertySource = null;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        block33: {
            if (adapterType != IPropertySource.class) break block33;
            Connection connection = (Connection)Adapters.adapt((Object)adaptableObject, Connection.class);
            if (connection != null) {
                if (this.currentConnectionPropertySource != null) {
                    this.currentConnectionPropertySource.dispose();
                }
                this.currentConnectionPropertySource = new ConnectionPropertySource((IConnection)connection);
                return this.currentConnectionPropertySource;
            }
            IResource resource = (IResource)Adapters.adapt((Object)adaptableObject, IResource.class);
            if (resource == null) break block33;
            switch (resource.getKind()) {
                case "Build": {
                    return new BuildPropertySource((IBuild)resource);
                }
                case "BuildConfig": {
                    return new BuildConfigPropertySource((IBuildConfig)resource);
                }
                case "Event": {
                    return new EventPropertySource((IEvent)resource);
                }
                case "ImageStream": {
                    return new ImageStreamPropertySource((IImageStream)resource);
                }
                case "Pod": {
                    return new PodPropertySource((IPod)resource);
                }
                case "ReplicationController": {
                    return new ReplicationControllerPropertySource((IReplicationController)resource);
                }
                case "Route": {
                    return new RoutePropertySource((IRoute)resource);
                }
                case "Service": {
                    return new ServicePropertySource((IService)resource);
                }
                case "PersistentVolumeClaim": {
                    return new StoragePropertySource((IPersistentVolumeClaim)resource);
                }
            }
            return new ResourcePropertySource<IResource>(resource);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IPropertySource.class};
    }
}

