/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IResource;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;

public class OpenShiftResourceInput
implements IStorageEditorInput {
    private IStorage storage;
    private Connection connection;
    private IResource input;

    public OpenShiftResourceInput(Connection connection, IResource resource) {
        this.connection = connection;
        this.input = resource;
        this.storage = new IStorage(){

            public InputStream getContents() throws CoreException {
                try {
                    return IOUtils.toBufferedInputStream((InputStream)IOUtils.toInputStream((String)OpenShiftResourceInput.this.input.toJson(), (String)"UTF-8"));
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.ui", "Unable to edit input", (Throwable)e));
                }
            }

            public IPath getFullPath() {
                return new Path(OpenShiftResourceInput.this.input.getNamespace()).append(OpenShiftResourceInput.this.input.getKind()).append(String.valueOf(OpenShiftResourceInput.this.input.getName()) + ".json");
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public String getName() {
                StringBuilder sb = new StringBuilder().append("[").append(OpenShiftResourceInput.this.input.getNamespace()).append("] ").append(StringUtils.humanize((String)OpenShiftResourceInput.this.input.getKind())).append(" : ").append(OpenShiftResourceInput.this.input.getName()).append(".json");
                return sb.toString();
            }

            public boolean isReadOnly() {
                return false;
            }
        };
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_ICON;
    }

    public String getName() {
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public String getToolTipText() {
        return this.storage.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public IResource getResource() {
        return this.input;
    }

    public void setResource(IResource newResource) {
        this.input = newResource;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenShiftResourceInput other = (OpenShiftResourceInput)obj;
        if (this.connection == null ? other.connection != null : !this.connection.equals((Object)other.connection)) {
            return false;
        }
        return !(this.input == null ? other.input != null : !this.input.equals(other.input));
    }
}

