/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property.build;

import com.openshift.restclient.model.build.IBuildTrigger;
import com.openshift.restclient.model.build.IWebhookTrigger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class WebHooksPropertySource
implements IPropertySource {
    private static final String GITHUB = "GitHub";
    private static final String GENERIC = "Generic";
    private IWebhookTrigger genericTrigger;
    private IWebhookTrigger gitTrigger;

    public WebHooksPropertySource(Collection<IBuildTrigger> triggers) {
        for (IBuildTrigger trigger : triggers) {
            switch (trigger.getType()) {
                case "generic": 
                case "Generic": {
                    this.genericTrigger = (IWebhookTrigger)trigger;
                    break;
                }
                case "github": 
                case "GitHub": {
                    this.gitTrigger = (IWebhookTrigger)trigger;
                }
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(2);
        if (this.genericTrigger != null) {
            descriptors.add(new PropertyDescriptor((Object)GENERIC, "Generic URL"));
        }
        if (this.gitTrigger != null) {
            descriptors.add(new PropertyDescriptor((Object)GITHUB, "Github URL"));
        }
        return descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (GENERIC.equals(id)) {
            return this.genericTrigger.getWebhookURL();
        }
        if (GITHUB.equals(id)) {
            return this.gitTrigger.getWebhookURL();
        }
        return null;
    }

    public boolean isPropertySet(Object arg0) {
        return false;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }
}

