/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.route;

import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.openshift.core.IRouteChooser;
import org.jboss.tools.openshift.internal.ui.dialog.SelectRouteDialog;

public class RouteChooser
implements IRouteChooser {
    private static final String NO_ROUTE_MSG = "Could not find a route that points to an url to show in a browser.";
    private boolean rememberChoice = false;

    public IRoute chooseRoute(List<IRoute> routes) {
        IRoute[] selectedRoute = new IRoute[1];
        Display.getDefault().syncExec(() -> {
            SelectRouteDialog routeDialog = new SelectRouteDialog(routes, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            if (routeDialog.open() == 0) {
                iRouteArray[0] = routeDialog.getSelectedRoute();
                this.rememberChoice = routeDialog.isRememberChoice();
            }
        });
        return selectedRoute[0];
    }

    public boolean isRememberChoice() {
        return this.rememberChoice;
    }

    public void noRouteErrorDialog() {
        Display.getDefault().syncExec(() -> MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No route to open", (String)NO_ROUTE_MSG));
    }
}

