/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IBuildConfig;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;

public class BuildConfigDetailViews
extends AbstractStackedDetailViews {
    private final AbstractStackedDetailViews.IDetailView templateView = new TemplateDetailView();

    public BuildConfigDetailViews(IObservableValue serviceObservable, Composite parent, DataBindingContext dbc) {
        super(serviceObservable, null, parent, dbc);
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.templateView.createControls(parent, context, dbc);
        this.emptyView.createControls(parent, context, dbc);
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.templateView, this.emptyView};
    }

    private class TemplateDetailView
    extends AbstractStackedDetailViews.EmptyView {
        private StyledText nameText;
        private StyledText namespaceText;
        private StyledText labelsText;
        private StyledText sourceURIText;
        private StyledText outputRepositoryNameText;

        private TemplateDetailView() {
            super((AbstractStackedDetailViews)BuildConfigDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(8, 2).spacing(6, 2).applyTo(container);
            this.nameText = this.createLabeledValue("Name:", container);
            this.namespaceText = this.createLabeledValue("Namespace:", container);
            this.labelsText = this.createLabeledValue("Labels:", container);
            this.sourceURIText = this.createLabeledValue("Source URI:", container);
            this.outputRepositoryNameText = this.createLabeledValue("Output repository:", container);
            return container;
        }

        public void onVisible(IObservableValue serviceObservable, DataBindingContext dbc) {
            Object value = serviceObservable.getValue();
            if (!(value instanceof IBuildConfig)) {
                return;
            }
            IBuildConfig buildConfig = (IBuildConfig)value;
            this.nameText.setText(buildConfig.getName());
            this.namespaceText.setText(buildConfig.getNamespace());
            String labels = org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)buildConfig.getLabels());
            labels = StringUtils.defaultString((String)labels);
            this.labelsText.setText(labels);
            this.sourceURIText.setText(buildConfig.getSourceURI());
            this.outputRepositoryNameText.setText(buildConfig.getOutputRepositoryName());
        }

        public boolean isViewFor(Object object) {
            return object instanceof IBuildConfig;
        }
    }
}

