/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;

public class ResourceDetailViews
extends AbstractStackedDetailViews {
    private final AbstractStackedDetailViews.IDetailView projectView = new ProjectDetailView();
    private final AbstractStackedDetailViews.IDetailView serviceView = new ServiceDetailView();
    private final AbstractStackedDetailViews.IDetailView replicationControllerView = new ReplicationControllerDetailView();

    public ResourceDetailViews(IObservableValue serviceObservable, Composite parent, DataBindingContext dbc) {
        super(serviceObservable, null, parent, dbc);
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.projectView.createControls(parent, context, dbc);
        this.serviceView.createControls(parent, context, dbc);
        this.replicationControllerView.createControls(parent, context, dbc);
        this.emptyView.createControls(parent, context, dbc);
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.projectView, this.serviceView, this.replicationControllerView, this.emptyView};
    }

    private class ProjectDetailView
    extends ResourceDetailView {
        private ProjectDetailView() {
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof IProject;
        }
    }

    private abstract class ProjectResourceDetailView
    extends ResourceDetailView {
        private StyledText namespaceText;
        private StyledText labelsText;

        private ProjectResourceDetailView() {
        }

        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = super.createControls(parent, context, dbc);
            this.namespaceText = this.createLabeledValue("Namespace:", container);
            this.labelsText = this.createLabeledValue("Labels:", container);
            return container;
        }

        @Override
        public void onVisible(IObservableValue resourceObservable, DataBindingContext dbc) {
            super.onVisible(resourceObservable, dbc);
            Object value = resourceObservable.getValue();
            if (!(value instanceof IResource)) {
                return;
            }
            IResource resource = (IResource)value;
            this.namespaceText.setText(resource.getNamespace());
            String labels = org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)resource.getLabels());
            labels = StringUtils.defaultString((String)labels);
            this.labelsText.setText(labels);
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof IResource;
        }
    }

    private class ReplicationControllerDetailView
    extends ProjectResourceDetailView {
        private StyledText selectorsText;

        private ReplicationControllerDetailView() {
        }

        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = super.createControls(parent, context, dbc);
            this.selectorsText = this.createLabeledValue("Selectors:", container);
            return container;
        }

        @Override
        public void onVisible(IObservableValue serviceObservable, DataBindingContext dbc) {
            super.onVisible(serviceObservable, dbc);
            Object value = serviceObservable.getValue();
            if (!(value instanceof IReplicationController)) {
                return;
            }
            IReplicationController replicationController = (IReplicationController)value;
            String selectors = org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)replicationController.getReplicaSelector());
            selectors = StringUtils.defaultString((String)selectors);
            this.selectorsText.setText(selectors);
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof IReplicationController;
        }
    }

    private abstract class ResourceDetailView
    extends AbstractStackedDetailViews.EmptyView {
        private StyledText kindText;
        private StyledText nameText;

        private ResourceDetailView() {
            super((AbstractStackedDetailViews)ResourceDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(8, 2).spacing(6, 2).applyTo(container);
            this.kindText = this.createLabeledValue("Kind:", container);
            this.nameText = this.createLabeledValue("Name:", container);
            return container;
        }

        public void onVisible(IObservableValue resourceObservable, DataBindingContext dbc) {
            Object value = resourceObservable.getValue();
            if (!(value instanceof IResource)) {
                return;
            }
            IResource resource = (IResource)value;
            this.kindText.setText(resource.getKind());
            this.nameText.setText(resource.getName());
        }

        public boolean isViewFor(Object object) {
            return object instanceof IResource;
        }
    }

    private class ServiceDetailView
    extends ProjectResourceDetailView {
        private StyledText selectorsText;
        private StyledText ipText;
        private StyledText portText;

        private ServiceDetailView() {
        }

        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = super.createControls(parent, context, dbc);
            this.selectorsText = this.createLabeledValue("Selectors:", container);
            this.ipText = this.createLabeledValue("IP:", container);
            this.portText = this.createLabeledValue("Port:", container);
            return container;
        }

        @Override
        public void onVisible(IObservableValue serviceObservable, DataBindingContext dbc) {
            super.onVisible(serviceObservable, dbc);
            Object value = serviceObservable.getValue();
            if (!(value instanceof IService)) {
                return;
            }
            IService service = (IService)value;
            String selectors = org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)service.getSelector());
            selectors = StringUtils.defaultString((String)selectors);
            this.selectorsText.setText(selectors);
            this.ipText.setText(StringUtils.join((Object[])new String[]{service.getPortalIP(), org.jboss.tools.openshift.common.core.utils.StringUtils.toStringOrNull((Object)service.getTargetPort())}, (char)':'));
            this.portText.setText(org.jboss.tools.openshift.common.core.utils.StringUtils.toStringOrNull((Object)service.getPort()));
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof IService;
        }
    }
}

