/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.Map;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ResourcesViewLabelProvider
extends StyledCellLabelProvider {
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (!(element instanceof ObservableTreeItem)) {
            return;
        }
        if (!(((ObservableTreeItem)((Object)element)).getModel() instanceof IResource)) {
            return;
        }
        IResource resource = (IResource)((ObservableTreeItem)((Object)element)).getModel();
        StyledString text = new StyledString();
        if (resource instanceof IProject) {
            this.createProjectLabel(text, (IProject)resource);
        } else if (resource instanceof IService) {
            this.createServiceLabel(text, (IService)resource);
        } else if (resource instanceof IReplicationController) {
            this.createReplicationControllerLabel(text, (IReplicationController)resource);
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    private void createProjectLabel(StyledString text, IProject resource) {
        text.append(resource.getName());
    }

    private void createServiceLabel(StyledString text, IService service) {
        text.append(service.getName());
        String selectorsDecoration = StringUtils.toString((Map)service.getSelector());
        if (!StringUtils.isEmpty((String)selectorsDecoration)) {
            text.append(" ", StyledString.DECORATIONS_STYLER);
            text.append(selectorsDecoration, StyledString.DECORATIONS_STYLER);
        }
    }

    private void createReplicationControllerLabel(StyledString text, IReplicationController rc) {
        text.append(rc.getName());
        String selectorsDecoration = StringUtils.toString((Map)rc.getReplicaSelector());
        if (!StringUtils.isEmpty((String)selectorsDecoration)) {
            text.append(" ", StyledString.DECORATIONS_STYLER);
            text.append(selectorsDecoration, StyledString.DECORATIONS_STYLER);
        }
    }
}

