/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.utils.ObservableTreeItemUtils;

public class ServerResourceViewModel
extends ObservablePojo {
    public static final String PROPERTY_CONNECTION = "connection";
    public static final String PROPERTY_CONNECTIONS = "connections";
    public static final String PROPERTY_RESOURCE = "resource";
    public static final String PROPERTY_RESOURCE_ITEMS = "resourceItems";
    private boolean isLoaded = false;
    private Connection connection;
    private List<Connection> connections = new ArrayList<Connection>();
    private List<ObservableTreeItem> resourceItems = new ArrayList<ObservableTreeItem>();
    protected IResource resource;

    public ServerResourceViewModel(Connection connection) {
        this(null, connection);
    }

    public ServerResourceViewModel(IResource resource, Connection connection) {
        this.connection = connection;
        this.resource = resource;
    }

    protected void update(Connection connection, List<Connection> connections, IResource resource, List<ObservableTreeItem> resourceItems) {
        this.updateConnections(connections);
        this.updateConnection(connection);
        this.updateResourceItems(resourceItems);
        this.updateResource(resource, resourceItems);
    }

    protected void updateConnection(Connection connection) {
        this.connection = connection;
        this.firePropertyChange(PROPERTY_CONNECTION, this.connection, this.connection);
    }

    private void updateConnections(List<Connection> newConnections) {
        ArrayList<Connection> oldItems = new ArrayList<Connection>(this.connections);
        if (newConnections != this.connections) {
            this.connections.clear();
            if (newConnections != null) {
                this.connections.addAll(newConnections);
            }
            this.firePropertyChange(PROPERTY_CONNECTIONS, oldItems, this.connections);
        }
    }

    private void updateResourceItems(List<ObservableTreeItem> newResourceItems) {
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.resourceItems);
        if (newResourceItems != this.resourceItems) {
            this.resourceItems.clear();
            if (newResourceItems != null) {
                this.resourceItems.addAll(newResourceItems);
            }
            this.firePropertyChange(PROPERTY_RESOURCE_ITEMS, oldItems, this.resourceItems);
        }
    }

    protected IResource updateResource(IResource resource, List<ObservableTreeItem> resourceItems) {
        IResource newResource;
        if (!this.isLoaded) {
            return resource;
        }
        this.resource = newResource = this.getResourceOrDefault(resource, resourceItems);
        this.firePropertyChange(PROPERTY_RESOURCE, null, this.resource);
        return newResource;
    }

    public void setConnections(List<Connection> connections) {
        this.update(this.connection, connections, this.resource, this.resourceItems);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnection(Connection connection) {
        if (this.connection != connection) {
            this.update(connection, this.connections, null, Collections.emptyList());
        }
    }

    public List<ObservableTreeItem> getResourceItems() {
        return this.resourceItems;
    }

    protected void setResourceItems(List<ObservableTreeItem> items) {
        this.update(this.connection, this.connections, this.resource, items);
    }

    public IResource getResource() {
        if (!this.isLoaded) {
            return null;
        }
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.update(this.connection, this.connections, resource, this.resourceItems);
    }

    protected IProject getOpenShiftProject(IResource resource) {
        return resource.getProject();
    }

    protected IResource getResourceOrDefault(IResource resource, List<ObservableTreeItem> items) {
        if (resource == null || !ObservableTreeItemUtils.contains(resource, items)) {
            IResource newResource = (IResource)ObservableTreeItemUtils.getFirstModel(IService.class, items);
            if (newResource == null && (newResource = (IResource)ObservableTreeItemUtils.getFirstModel(IDeploymentConfig.class, items)) == null) {
                newResource = (IResource)ObservableTreeItemUtils.getFirstModel(IReplicationController.class, items);
            }
            return newResource;
        }
        return resource;
    }

    public IService getService(String serviceName) {
        if (this.resourceItems != null) {
            return this.resourceItems.stream().flatMap(ObservableTreeItemUtils::flatten).filter(item -> item.getModel() instanceof IService).map(item -> (IService)item.getModel()).filter(service -> service.getName().equals(serviceName)).findFirst().orElseGet(() -> null);
        }
        return null;
    }

    public void loadResources() {
        this.loadResources(this.getConnection());
    }

    public void loadResources(Connection connection) {
        this.isLoaded = false;
        this.setConnections(this.loadConnections());
        this.setConnection(connection);
        if (connection != null) {
            List<ObservableTreeItem> serviceItems = this.loadServices(connection);
            this.setResourceItems(serviceItems);
        }
        this.isLoaded = true;
        this.update(this.connection, this.connections, this.resource, this.resourceItems);
    }

    private List<Connection> loadConnections() {
        return new ArrayList<Connection>(ConnectionsRegistrySingleton.getInstance().getAll(Connection.class));
    }

    protected List<ObservableTreeItem> loadServices(Connection connection) {
        if (connection == null) {
            return null;
        }
        ObservableTreeItem connectionItem = ResourceTreeItemsFactory.INSTANCE.create(connection);
        connectionItem.load();
        return connectionItem.getChildren();
    }

    static class ResourceTreeItemsFactory
    implements IModelFactory {
        private static final ResourceTreeItemsFactory INSTANCE = new ResourceTreeItemsFactory();

        ResourceTreeItemsFactory() {
        }

        @Override
        public <T> List<T> createChildren(Object parent) {
            if (parent instanceof Connection) {
                return ((Connection)parent).getResources("Project");
            }
            if (parent instanceof IProject) {
                return this.getProjectResources((IProject)parent);
            }
            return Collections.emptyList();
        }

        private List<IResource> getProjectResources(IProject project) {
            List services = project.getResources("Service");
            List dcConfigs = project.getResources("DeploymentConfig");
            ArrayList<IResource> resources = new ArrayList<IResource>(services);
            resources.addAll(this.getNonLinkedDcs(services, dcConfigs, project));
            resources.addAll(this.getNonLinkeRcs(dcConfigs, project));
            return resources;
        }

        private List<IDeploymentConfig> getNonLinkedDcs(List<? extends IResource> services, List<IDeploymentConfig> dcConfigs, IProject project) {
            ArrayList<IDeploymentConfig> nonLinkedDcConfigs = new ArrayList<IDeploymentConfig>();
            List allPods = project.getResources("Pod");
            dcConfigs.stream().filter(dc -> !services.stream().anyMatch(service -> ResourceUtils.areRelated((IService)((IService)service), (IDeploymentConfig)dc, (Collection)allPods))).forEach(dc -> {
                boolean bl = nonLinkedDcConfigs.add((IDeploymentConfig)dc);
            });
            return nonLinkedDcConfigs;
        }

        private List<IReplicationController> getNonLinkeRcs(List<IDeploymentConfig> dcConfigs, IProject project) {
            List allRcs = project.getResources("ReplicationController");
            List<IReplicationController> nonLinkedReplicationControllers = allRcs.stream().filter(rc -> !dcConfigs.stream().anyMatch(dc -> ResourceUtils.areRelated((IReplicationController)rc, (IDeploymentConfig)dc))).collect(Collectors.toList());
            return nonLinkedReplicationControllers;
        }

        @Override
        public ObservableTreeItem create(Object object) {
            return new ObservableTreeItem(object, this);
        }
    }
}

