/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.server.OpenShiftServerTaskModelAccessor;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsWizardPage;
import org.jboss.tools.openshift.internal.ui.server.WizardFragmentUtils;
import org.jboss.tools.openshift.internal.ui.server.WizardHandleAwareFragment;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ServerSettingsWizardFragment
extends WizardHandleAwareFragment
implements DeploymentTypeUIUtil.ICompletable {
    static final String IS_LOADING_SERVICES = "isLoadingServices";
    private PropertyChangeListener connectionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IWizardContainer wizardContainer = ServerSettingsWizardFragment.this.getWizardContainer();
            if (ServerSettingsWizardFragment.this.serverSettingsWizardPage == null || ServerSettingsWizardFragment.this.serverSettingsWizardPage.getModel() == null || wizardContainer == null) {
                return;
            }
            if ("selectedConnection".equals(evt.getPropertyName())) {
                Connection newConnection;
                if ((evt.getNewValue() == null || evt.getNewValue() instanceof Connection) && (newConnection = (Connection)evt.getNewValue()) != ServerSettingsWizardFragment.this.serverSettingsWizardPage.getModel().getConnection() && wizardContainer != null) {
                    ((ServerSettingsWizardFragment)ServerSettingsWizardFragment.this).serverSettingsWizardPage.needsLoadingResources = true;
                    ServerSettingsWizardFragment.this.serverSettingsWizardPage.getModel().setConnection(newConnection);
                    ServerSettingsWizardFragment.this.serverSettingsWizardPage.getModel().setResourceItems(new ArrayList<ObservableTreeItem>());
                    ServerSettingsWizardFragment.this.serverSettingsWizardPage.setComplete(false);
                    wizardContainer.updateButtons();
                }
            } else if ("connectedStatus".equals(evt.getPropertyName())) {
                ((ServerSettingsWizardFragment)ServerSettingsWizardFragment.this).serverSettingsWizardPage.needsLoadingResources = true;
                ServerSettingsWizardFragment.this.serverSettingsWizardPage.getModel().setResourceItems(new ArrayList<ObservableTreeItem>());
                ServerSettingsWizardFragment.this.serverSettingsWizardPage.setComplete(false);
                wizardContainer.updateButtons();
            }
        }
    };
    private ServerSettingsWizardPageWrapper serverSettingsWizardPage;

    public ServerSettingsWizardFragment() {
        this.setComplete(false);
    }

    public PropertyChangeListener getConnectionChangeListener() {
        return this.connectionChangeListener;
    }

    public boolean hasComposite() {
        return true;
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.serverSettingsWizardPage != null) {
            this.serverSettingsWizardPage.updateServer();
            this.serverSettingsWizardPage.unhook();
        }
        super.performFinish(monitor);
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
        if (this.serverSettingsWizardPage != null) {
            this.serverSettingsWizardPage.unhook();
        }
        super.performCancel(monitor);
    }

    public void setComplete(boolean complete) {
        super.setComplete(complete);
    }

    public boolean isComplete() {
        return this.serverSettingsWizardPage != null && !this.serverSettingsWizardPage.isLoadingResources() && !this.serverSettingsWizardPage.isNeedsLoadingResources() && this.serverSettingsWizardPage.getModel().getResource() != null && this.serverSettingsWizardPage.isPageComplete();
    }

    @Override
    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.setHandle(handle);
        this.serverSettingsWizardPage = this.createServerSettingsWizardPage(parent, handle);
        this.updateWizardHandle(handle, this.serverSettingsWizardPage);
        WizardFragmentUtils.getWizardDialog(handle).addPageChangingListener(this.onPageChanging());
        return (Composite)this.serverSettingsWizardPage.getControl();
    }

    private ServerSettingsWizardPageWrapper createServerSettingsWizardPage(Composite parent, IWizardHandle handle) {
        ServerSettingsWizardPageWrapper serverSettingsWizardPage = new ServerSettingsWizardPageWrapper(handle, this.getTaskModel());
        serverSettingsWizardPage.getModel().addPropertyChangeListener(this.connectionChangeListener);
        serverSettingsWizardPage.createControl(parent);
        return serverSettingsWizardPage;
    }

    private void updateWizardHandle(IWizardHandle handle, ServerSettingsWizardPageWrapper serverSettingsWizardPage) {
        handle.setTitle(serverSettingsWizardPage.getTitle());
        handle.setDescription(serverSettingsWizardPage.getDescription());
        handle.setImageDescriptor(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM);
    }

    private IPageChangingListener onPageChanging() {
        return new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (ServerSettingsWizardFragment.this.serverSettingsWizardPage != null) {
                    ServerSettingsWizardFragment.this.serverSettingsWizardPage.reloadServices();
                }
            }
        };
    }

    protected ModifyListener onFilterTextModified(final TreeViewer applicationTemplatesViewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                applicationTemplatesViewer.refresh();
                applicationTemplatesViewer.expandAll();
            }
        };
    }

    class ServerSettingsWizardPageWrapper
    extends ServerSettingsWizardPage {
        private IWizardHandle wizardHandle;

        private ServerSettingsWizardPageWrapper(IWizardHandle wizardHandle, TaskModel taskModel) {
            super(((IWizardPage)wizardHandle).getWizard(), OpenShiftServerTaskModelAccessor.getServer(taskModel), OpenShiftServerTaskModelAccessor.getConnection(taskModel), UIUtils.getFirstSelectedWorkbenchProject());
            this.wizardHandle = wizardHandle;
        }

        boolean isWizardDisposed() {
            return this.getContainer() == null || this.getContainer().getShell() == null || this.getContainer().getShell().isDisposed();
        }

        public void setPageComplete(boolean complete) {
            super.setPageComplete(complete);
            if (!this.isWizardDisposed()) {
                this.wizardHandle.update();
            }
        }

        public void setErrorMessage(String newMessage) {
            if (!this.isWizardDisposed()) {
                ((WizardPage)this.wizardHandle).setErrorMessage(newMessage);
            }
        }

        public void setMessage(String newMessage, int newType) {
            if (!this.isWizardDisposed()) {
                this.wizardHandle.setMessage(newMessage, newType);
            }
        }

        public void onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event) {
            this.onPageWillGetDeactivated(direction, event, null);
        }

        void reloadServices() {
            IWizardContainer container = this.getContainer();
            if (!this.needsLoadingResources || container == null) {
                return;
            }
            try {
                try {
                    this.isLoadingResources = true;
                    ServerSettingsWizardFragment.this.getTaskModel().putObject(ServerSettingsWizardFragment.IS_LOADING_SERVICES, (Object)this.isLoadingResources);
                    container.updateButtons();
                    WizardUtils.runInWizard((Job)new Job("Loading services..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (!ServerSettingsWizardPageWrapper.this.isWizardDisposed()) {
                                ServerSettingsWizardPageWrapper.this.model.loadResources();
                                ServerSettingsWizardPageWrapper.this.needsLoadingResources = false;
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)container);
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    this.needsLoadingResources = false;
                    this.isLoadingResources = false;
                    ServerSettingsWizardFragment.this.getTaskModel().putObject(ServerSettingsWizardFragment.IS_LOADING_SERVICES, (Object)this.isLoadingResources);
                    if (!this.isWizardDisposed()) {
                        container.updateButtons();
                    }
                }
            }
            finally {
                this.needsLoadingResources = false;
                this.isLoadingResources = false;
                ServerSettingsWizardFragment.this.getTaskModel().putObject(ServerSettingsWizardFragment.IS_LOADING_SERVICES, (Object)this.isLoadingResources);
                if (!this.isWizardDisposed()) {
                    container.updateButtons();
                }
            }
        }

        void unhook() {
            this.uiHook = null;
            this.model = null;
        }
    }
}

