/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class DockerImageValidator
implements IValidator {
    private String hostnameComponentRegexp = "(?:[a-z0-9]|[a-z0-9][a-z0-9-]*[a-z0-9])";
    private String hostnameRegexp = "(?:" + this.hostnameComponentRegexp + "\\.)*" + this.hostnameComponentRegexp + "(?::[0-9]+)?";
    private String tagRegexp = "[\\w][\\w.-]{0,127}";
    private String nameSubComponentRegexp = "[a-z0-9]+(?:[-]+[a-z0-9]+)*";
    private String nameComponentRegexp = String.valueOf(this.nameSubComponentRegexp) + "(?:(?:[._]|__)" + this.nameSubComponentRegexp + ")*";
    private String nameRegexp = "(?:" + this.nameComponentRegexp + "/)*" + this.nameComponentRegexp;
    private String digestRegexp = "[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][[:xdigit:]]{32,}";
    private String referenceRegexp = "^((?:" + this.hostnameRegexp + "/)?" + this.nameRegexp + ")(?:[:](" + this.tagRegexp + "))?(?:[@](" + this.digestRegexp + "))?$";
    private Pattern IMAGE_PATTERN = Pattern.compile(this.referenceRegexp);
    private static String ERROR_MSG = "Please provide an existing docker image in the format of [[<repo>/]<namespace>/]<name>[:<tag>].\n The defaults are: repo=docker.io, namespace=library, tag=latest";

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.cancel((String)ERROR_MSG);
        }
        String name = (String)value;
        IStatus status = this.validateImageName(name);
        if (status.isOK()) {
            status = this.additionalValidation(name);
        }
        return status;
    }

    public IStatus validateImageName(String repoName) {
        String uri = repoName;
        if (StringUtils.isEmpty((String)uri) || uri.contains("://")) {
            return ValidationStatus.cancel((String)ERROR_MSG);
        }
        Matcher matcher = this.IMAGE_PATTERN.matcher(repoName);
        if (!matcher.matches()) {
            return ValidationStatus.cancel((String)ERROR_MSG);
        }
        return ValidationStatus.ok();
    }

    public IStatus additionalValidation(String repoName) {
        return ValidationStatus.ok();
    }
}

