/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.ui.validator.LabelValueValidator;

public class LabelKeyValidator
extends LabelValueValidator {
    public static final int SUBDOMAIN_MAXLENGTH = 253;
    private static final Pattern SUBDOMAIN_REGEXP = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$");
    private Collection<String> readonlykeys;
    private Collection<String> usedKeys;
    public static final String keyDescription = "A valid label key has the form [domain/]name where name is required,\nmust be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z])\nwith dashes (-), underscores (_), dots (.), and alphanumerics between.\nA domain is an optional sequence of names separated by the '.' character with a maximum length of 253 characters.";
    private final IStatus FAILED = ValidationStatus.error((String)"A valid label key has the form [domain/]name where name is required,\nmust be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z])\nwith dashes (-), underscores (_), dots (.), and alphanumerics between.\nA domain is an optional sequence of names separated by the '.' character with a maximum length of 253 characters.");

    private static boolean isLowerCaseAlphaNumeric(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static boolean isLowerCaseAlphaNumericOrDash(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-';
    }

    private static String[] getSubdomainParts(String domain) {
        return domain.split("\\.");
    }

    public LabelKeyValidator(Collection<String> readonlykeys, Collection<String> usedKeys) {
        super("label key");
        this.readonlykeys = readonlykeys != null ? readonlykeys : new ArrayList(0);
        this.usedKeys = usedKeys != null ? usedKeys : new ArrayList(0);
    }

    @Override
    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)this.getValueIsNotAStringMessage());
        }
        String value = (String)paramObject;
        if (StringUtils.isEmpty((String)value)) {
            return ValidationStatus.cancel((String)NLS.bind((String)"{0} is required", (Object)this.type));
        }
        if (this.readonlykeys.contains(value)) {
            return ValidationStatus.error((String)"Adding a label with a key that is the same as a readonly label is not allowed");
        }
        if (this.usedKeys.contains(value)) {
            return ValidationStatus.error((String)"A label with this key exists");
        }
        if (value.endsWith("/")) {
            return ValidationStatus.error((String)NLS.bind((String)"A valid {0} must end with an alphanumeric character", (Object)this.type));
        }
        String[] parts = value.split("/");
        switch (parts.length) {
            case 1: {
                return super.validate(value);
            }
            case 2: {
                if (!this.validateSubdomain(parts[0])) {
                    if (parts[0].length() > 253) {
                        return ValidationStatus.error((String)NLS.bind((String)"Maximum length of domain of label key allowed is {0} characters", (Object)253));
                    }
                    return this.getSubdomainRegexError(parts[0], "domain of " + this.type);
                }
                if (!this.validateLabel(parts[1])) {
                    if (value.length() > 63) {
                        return ValidationStatus.error((String)NLS.bind((String)"Maximum length of name of label key allowed is {0} characters", (Object)63));
                    }
                    return this.getLabelRegexError(parts[1], "name of " + this.type);
                }
                return ValidationStatus.OK_STATUS;
            }
        }
        return ValidationStatus.error((String)NLS.bind((String)"More than one '/' is not allowed. A valid {0} has an optional domain separated by '/' from name", (Object)this.type));
    }

    private boolean validateSubdomain(String value) {
        if (value.length() > 253) {
            return false;
        }
        return SUBDOMAIN_REGEXP.matcher(value).matches();
    }

    protected IStatus getSubdomainRegexError(String value, String type) {
        String[] sparts;
        if (value.isEmpty()) {
            return ValidationStatus.error((String)NLS.bind((String)"A valid {0} cannot be empty if '/' is present.", (Object)type));
        }
        if (value.endsWith(".")) {
            return ValidationStatus.error((String)NLS.bind((String)"A valid {0} must end with a lower-case alphanumeric character.", (Object)type));
        }
        String[] stringArray = sparts = LabelKeyValidator.getSubdomainParts(value);
        int n = sparts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.isEmpty()) {
                return ValidationStatus.error((String)NLS.bind((String)"Two dots in a row are not allowed in {0}.", (Object)type));
            }
            if (!LabelKeyValidator.isLowerCaseAlphaNumeric(s.charAt(0))) {
                return ValidationStatus.error((String)NLS.bind((String)"A valid part of {0} must begin with a lower-case alphanumeric.", (Object)type));
            }
            int i = 1;
            while (i < s.length() - 1) {
                if (!LabelKeyValidator.isLowerCaseAlphaNumericOrDash(s.charAt(i))) {
                    return ValidationStatus.error((String)NLS.bind((String)"A character ''{0}'' is not allowed in {1}.", (Object)s.substring(i, i + 1), (Object)type));
                }
                ++i;
            }
            if (s.length() > 1 && !LabelKeyValidator.isLowerCaseAlphaNumeric(s.charAt(s.length() - 1))) {
                return ValidationStatus.error((String)NLS.bind((String)"A valid part of {0} must end with a lower-case alphanumeric character.", (Object)type));
            }
            ++n2;
        }
        return ValidationStatus.error((String)NLS.bind((String)"{0} is not valid.", (Object)type));
    }

    @Override
    protected IStatus getFailedStatus() {
        return this.FAILED;
    }
}

