/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class URLValidator
implements IValidator {
    private static final String[] SCHEMES = new String[]{"http", "https"};
    private final String invalidURLMessage;
    private boolean allowEmpty = false;
    private UrlValidator validator = new UrlValidator(SCHEMES, 8L){

        protected boolean isValidAuthority(String domain) {
            return true;
        }
    };

    public URLValidator(String urlType, boolean allowEmpty) {
        this.invalidURLMessage = NLS.bind((String)"Please provide a valid {0} (HTTP/S) URL.", (Object)urlType);
        this.allowEmpty = allowEmpty;
    }

    public IStatus validate(Object in) {
        String value = (String)in;
        if (this.allowEmpty && StringUtils.isBlank((String)value)) {
            return ValidationStatus.ok();
        }
        if (!this.validator.isValid(value)) {
            return ValidationStatus.error((String)this.invalidURLMessage);
        }
        return ValidationStatus.ok();
    }
}

