/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.common;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.comparators.ProjectViewerComparator;
import org.jboss.tools.openshift.internal.ui.explorer.OpenShiftExplorerLabelProvider;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.common.IProjectPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizard;

public class AbstractProjectPage<M extends IProjectPageModel<Connection>>
extends AbstractOpenShiftWizardPage {
    protected M model;

    public AbstractProjectPage(IWizard wizard, M model, String title, String description, String pageName) {
        super(title, description, pageName, wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(parent);
        this.createProjectControls(parent, dbc);
    }

    private void createProjectControls(Composite parent, DataBindingContext dbc) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText("OpenShift project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)projectLabel);
        ComboViewer projectsViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo(projectsViewer.getControl());
        OpenShiftExplorerLabelProvider labelProvider = new OpenShiftExplorerLabelProvider();
        projectsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemLabelProvider());
        projectsViewer.setInput((Object)BeanProperties.list((String)"projectItems").observe(this.model));
        projectsViewer.setComparator(ProjectViewerComparator.createProjectTreeSorter((ILabelProvider)labelProvider));
        this.model.setProjectsComparator(new ProjectViewerComparator((ILabelProvider)labelProvider).asItemComparator());
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)projectsViewer);
        Binding selectedProjectBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(IProject.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof IProject) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose an OpenShift project.");
            }
        })).to(BeanProperties.value((String)"project").observe(this.model)).converting((IConverter)new Model2ObservableTreeItemConverter(null))).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        IObservableValue connectionObservable = BeanProperties.value((String)"connection").observe(this.model);
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)this.onConnectionChanged(), (IObservableValue)connectionObservable, (Control)projectsViewer.getControl());
        Button newProjectButton = new Button(parent, 8);
        newProjectButton.setText("New...");
        GridDataFactory.fillDefaults().align(16384, 4).applyTo((Control)newProjectButton);
        UIUtils.setDefaultButtonWidth((Button)newProjectButton);
        newProjectButton.addSelectionListener((SelectionListener)this.onNewProjectClicked());
    }

    private IValueChangeListener onConnectionChanged() {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractProjectPage.this.loadResources(AbstractProjectPage.this.getPreviousPage() == null);
            }
        };
    }

    private SelectionAdapter onNewProjectClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new UIUpdatingJob("Opening projects wizard..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            return Status.OK_STATUS;
                        }

                        protected IStatus updateUI(IProgressMonitor monitor) {
                            IProject selectedProject;
                            NewProjectWizard newProjectWizard = new NewProjectWizard((Connection)(this).AbstractProjectPage.this.model.getConnection(), (this).AbstractProjectPage.this.model.getProjectItems().stream().map(it -> (IProject)it.getModel()).collect(Collectors.toList()));
                            int result = new OkCancelButtonWizardDialog(AbstractProjectPage.this.getShell(), (IWizard)newProjectWizard).open();
                            if (newProjectWizard.getProject() != null) {
                                AbstractProjectPage.this.loadResources(false);
                            }
                            if (result == 0 && (selectedProject = newProjectWizard.getProject()) != null) {
                                (this).AbstractProjectPage.this.model.setProject(selectedProject);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)AbstractProjectPage.this.getContainer());
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        };
    }

    protected JobChainBuilder getLoadResourcesJobBuilder(final boolean[] closeAfter, final boolean closeOnCancel) {
        JobChainBuilder builder = new JobChainBuilder((Job)new AbstractDelegatingMonitorJob("Loading projects..."){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    AbstractProjectPage.this.model.loadResources();
                }
                catch (OpenShiftException e) {
                    closeAfter[0] = closeOnCancel;
                    String problem = e.getStatus() == null ? e.getMessage() : e.getStatus().getMessage();
                    return OpenShiftUIActivator.statusFactory().errorStatus(problem, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        });
        builder.runWhenSuccessfullyDone((Job)new UIJob("Verifying required project..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!AbstractProjectPage.this.model.hasProjects()) {
                    List<IProject> projects = new ObservableTreeItem2ModelConverter().convert(AbstractProjectPage.this.model.getProjectItems());
                    Connection connection = (Connection)AbstractProjectPage.this.model.getConnection();
                    NewProjectWizard newProjectWizard = new NewProjectWizard(connection, projects);
                    if (1 == WizardUtils.openWizardDialog((IWizard)newProjectWizard, (Shell)AbstractProjectPage.this.getShell())) {
                        closeAfter[0] = closeOnCancel;
                        return Status.CANCEL_STATUS;
                    }
                    AbstractProjectPage.this.model.loadResources();
                    AbstractProjectPage.this.model.setProject(newProjectWizard.getProject());
                }
                return Status.OK_STATUS;
            }
        });
        return builder;
    }

    protected void loadResources(boolean closeOnCancel) {
        if (!this.model.hasConnection()) {
            return;
        }
        try {
            boolean[] closeAfter = new boolean[1];
            Job jobs = this.getLoadResourcesJobBuilder(closeAfter, closeOnCancel).build();
            WizardUtils.runInWizard((Job)jobs, (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDataBindingContext());
            if (closeAfter[0]) {
                if (Display.getCurrent() != null) {
                    WizardUtils.close((IWizard)this.getWizard());
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WizardUtils.close((IWizard)AbstractProjectPage.this.getWizard());
                        }
                    });
                }
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    protected void onPageActivated(DataBindingContext dbc) {
        this.loadResources(this.getPreviousPage() == null);
        this.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (AbstractProjectPage.this.getControl().isVisible()) {
                    ((Composite)AbstractProjectPage.this.getControl()).layout(true, true);
                    ((Composite)AbstractProjectPage.this.getControl()).update();
                    AbstractProjectPage.this.getControl().removePaintListener((PaintListener)this);
                }
            }
        });
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)13, (WizardPage)this, (DataBindingContext)dbc);
    }

    protected static boolean isFile(String path) {
        try {
            return StringUtils.isNotBlank((String)path) && Paths.get(VariablesHelper.replaceVariables((String)path), new String[0]).toFile().isFile();
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    protected static boolean exists(String path) {
        return StringUtils.isNotBlank((String)path) && Paths.get(VariablesHelper.replaceVariables((String)path), new String[0]).toFile().exists();
    }
}

