/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.common;

import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.handler.EditResourceLimitsPage;
import org.jboss.tools.openshift.internal.ui.wizard.common.EditResourceLimitsPageModel;

public class EditResourceLimitsHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        IResource resource = (IResource)UIUtils.getFirstElement((ISelection)UIUtils.getCurrentSelection((ExecutionEvent)event), IResource.class);
        final RetrieveDCOrRCJob job = new RetrieveDCOrRCJob(resource);
        new JobChainBuilder((Job)job).runWhenSuccessfullyDone((Job)new UIJob("Launching Edit Resource Limits Wizard..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IReplicationController dcOrRc = job.getDeplConfigOrReplController();
                if (dcOrRc == null) {
                    return Status.CANCEL_STATUS;
                }
                EditResourceLimitsHandler.this.editResources(HandlerUtil.getActiveShell((ExecutionEvent)event), dcOrRc, dcOrRc.getName());
                return Status.OK_STATUS;
            }
        }).schedule();
        return null;
    }

    protected void editResources(Shell shell, IReplicationController rc, String name) {
        EditResourceLimitsPageModel model = new EditResourceLimitsPageModel(rc);
        EditResourceLimitsWizard wizard = new EditResourceLimitsWizard(model, "Edit resource limits");
        new OkCancelButtonWizardDialog(shell, (IWizard)wizard).open();
    }

    class EditResourceLimitsWizard
    extends Wizard {
        private EditResourceLimitsPageModel model;

        public EditResourceLimitsWizard(EditResourceLimitsPageModel model, String title) {
            this.model = model;
            this.setWindowTitle(title);
        }

        public void addPages() {
            this.addPage((IWizardPage)new EditResourceLimitsPage(this.model, (IWizard)this));
        }

        public boolean performFinish() {
            this.model.dispose();
            new Job(NLS.bind((String)OpenShiftUIMessages.EditResourceLimitsJobTitle, (Object)this.model.getUpdatedReplicationController().getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IReplicationController rc = EditResourceLimitsWizard.this.model.getUpdatedReplicationController();
                        Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)rc);
                        connection.updateResource((IResource)rc);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        String message = NLS.bind((String)OpenShiftUIMessages.EditResourceLimitsJobErrorMessage, (Object)EditResourceLimitsWizard.this.model.getUpdatedReplicationController().getName());
                        OpenShiftUIActivator.getDefault().getLogger().logError(message, (Throwable)e);
                        return new Status(4, "org.jboss.tools.openshift.ui", message, (Throwable)e);
                    }
                }
            }.schedule();
            return true;
        }
    }

    private class RetrieveDCOrRCJob
    extends Job {
        private final IResource resource;
        private IReplicationController deploymentConfOrReplController;

        public RetrieveDCOrRCJob(IResource resource) {
            super("Retrieve Deployment Config or Replication Controller...");
            this.resource = resource;
            this.deploymentConfOrReplController = null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.deploymentConfOrReplController = this.getDeploymentConfigOrReplicationController(this.resource);
            if (this.deploymentConfOrReplController == null) {
                return OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not edit resources {0}: Could not find deployment config or replication controller", (Object)(this.resource == null ? "" : this.resource.getName())));
            }
            return Status.OK_STATUS;
        }

        private IReplicationController getDeploymentConfigOrReplicationController(IResource resource) {
            if (resource == null) {
                return null;
            }
            Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)resource);
            IDeploymentConfig dcOrRc = ResourceUtils.getDeploymentConfigFor((IResource)resource, (Connection)connection);
            if (dcOrRc == null) {
                if (resource instanceof IService) {
                    dcOrRc = ResourceUtils.getReplicationControllerFor((IService)((IService)resource), (List)resource.getProject().getResources("ReplicationController"));
                } else if (resource instanceof IReplicationController) {
                    dcOrRc = (IReplicationController)resource;
                } else if (resource instanceof IPod) {
                    dcOrRc = ResourceUtils.getDeploymentConfigOrReplicationControllerFor((IPod)((IPod)resource));
                }
            }
            return dcOrRc;
        }

        IReplicationController getDeplConfigOrReplController() {
            return this.deploymentConfOrReplController;
        }
    }
}

