/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.IEnvironmentVariablesPageModel;

public class EnvironmentVariablesPageModel
extends ObservablePojo
implements IEnvironmentVariablesPageModel {
    private List<EnvironmentVariable> environmentVariables = new ArrayList<EnvironmentVariable>();
    private Map<String, String> imageEnvVars = new HashMap<String, String>();
    private EnvironmentVariable selectedEnvironmentVariable = null;

    public Map<String, String> getImageEnvVars() {
        return Collections.unmodifiableMap(this.imageEnvVars);
    }

    @Override
    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public void setEnvironmentVariables(List<EnvironmentVariable> envVars) {
        this.environmentVariables = envVars;
        this.firePropertyChange("environmentVariables", this.environmentVariables, this.environmentVariables);
        this.imageEnvVars.clear();
        for (IKeyValueItem iKeyValueItem : envVars) {
            this.imageEnvVars.put(iKeyValueItem.getKey(), iKeyValueItem.getValue());
        }
    }

    @Override
    public void setSelectedEnvironmentVariable(EnvironmentVariable envVar) {
        this.selectedEnvironmentVariable = envVar;
        this.firePropertyChange("selectedEnvironmentVariable", this.selectedEnvironmentVariable, this.selectedEnvironmentVariable);
    }

    @Override
    public EnvironmentVariable getSelectedEnvironmentVariable() {
        return this.selectedEnvironmentVariable;
    }

    @Override
    public void removeEnvironmentVariable(EnvironmentVariable envVar) {
        if (this.isPersistent(envVar)) {
            this.updateEnvironmentVariable(envVar, envVar.getKey(), "&Deleted");
            return;
        }
        int i = this.environmentVariables.indexOf(envVar);
        if (i > -1) {
            ArrayList<EnvironmentVariable> old = new ArrayList<EnvironmentVariable>(this.environmentVariables);
            this.environmentVariables.remove(i);
            this.fireIndexedPropertyChange("environmentVariables", i, old, Collections.unmodifiableList(this.environmentVariables));
        }
    }

    @Override
    public void updateEnvironmentVariable(EnvironmentVariable envVar, String key, String value) {
        if ((this.isPersistent(envVar) || this.isPersistent(key)) && !key.equals(envVar.getKey())) {
            this.addEnvironmentVariable(key, value);
            this.removeEnvironmentVariable(envVar);
            return;
        }
        int i = this.environmentVariables.indexOf(envVar);
        if (i > -1) {
            ArrayList<EnvironmentVariable> old = new ArrayList<EnvironmentVariable>(this.environmentVariables);
            EnvironmentVariable prev = this.environmentVariables.get(i);
            this.environmentVariables.set(i, new EnvironmentVariable(key, value, prev.isNew()));
            this.fireIndexedPropertyChange("environmentVariables", i, old, Collections.unmodifiableList(this.environmentVariables));
        }
    }

    @Override
    public void resetEnvironmentVariable(EnvironmentVariable envVar) {
        if (this.isPersistent(envVar)) {
            this.updateEnvironmentVariable(envVar, envVar.getKey(), this.imageEnvVars.get(envVar.getKey()));
        }
    }

    @Override
    public void addEnvironmentVariable(String key, String value) {
        EnvironmentVariable envVar;
        if (this.isPersistent(key) && (envVar = this.find(key)) != null) {
            this.updateEnvironmentVariable(envVar, key, value);
            return;
        }
        ArrayList<EnvironmentVariable> old = new ArrayList<EnvironmentVariable>(this.environmentVariables);
        this.environmentVariables.add(new EnvironmentVariable(key, value, true));
        this.firePropertyChange("environmentVariables", old, Collections.unmodifiableList(this.environmentVariables));
    }

    @Override
    public boolean isEnvironmentVariableModified(EnvironmentVariable envVar) {
        return envVar.isNew() || this.isPersistent(envVar) && !Objects.equals(this.imageEnvVars.get(envVar.getKey()), envVar.getValue());
    }

    @Override
    public EnvironmentVariable getEnvironmentVariable(String key) {
        return this.environmentVariables.stream().filter(var -> key.equals(var.getKey())).findAny().orElse(null);
    }

    public boolean isPersistent(EnvironmentVariable envVar) {
        return this.isPersistent(envVar.getKey());
    }

    public boolean isPersistent(String envVarKey) {
        return this.imageEnvVars.containsKey(envVarKey);
    }

    public EnvironmentVariable find(String key) {
        return this.environmentVariables.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }
}

