/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionFactory;
import org.jboss.tools.openshift.core.connection.registry.RegistryProviderModel;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.connection.IAdvancedConnectionPropertiesEditor;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimTrailingSlashConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.detailviews.BaseDetailsView;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DialogAdvancedPart;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.core.preferences.OCBinaryVersionValidator;
import org.jboss.tools.openshift.internal.ui.validator.URLValidator;
import org.osgi.framework.Version;

public class AdvancedConnectionEditor
extends BaseDetailsView
implements IAdvancedConnectionPropertiesEditor {
    private static final String VALIDATOR_URL_TYPE = "image registry";
    private static final int DELAY = 500;
    private AdvancedConnectionEditorModel model;
    private ConnectionWizardPageModel pageModel;
    private IObservableValue selectedConnection;
    private IValueChangeListener connectionChangedListener;
    private IObservableValue registryURLObservable;
    private IObservableValue clusterNamespaceObservable;
    private ConnectionWizardPageModel.IConnectionAdvancedPropertiesProvider connectionAdvancedPropertiesProvider;
    Map<String, Object> extendedProperties = null;
    private IObservableValue<IStatus> ocLocationValidity = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
    private IObservableValue<IStatus> ocVersionValidity = new WritableValue((Object)Status.OK_STATUS, IStatus.class);

    public Composite createControls(Composite parent, Object context, final DataBindingContext dbc) {
        this.pageModel = (ConnectionWizardPageModel)context;
        this.selectedConnection = BeanProperties.value((String)"selectedConnection").observe((Object)this.pageModel);
        this.model = new AdvancedConnectionEditorModel();
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().applyTo(composite);
        DialogAdvancedPart part = new DialogAdvancedPart(){

            protected void createAdvancedContent(Composite advancedComposite) {
                Label lblRegistry = new Label(advancedComposite, 0);
                lblRegistry.setText("Image Registry URL:");
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblRegistry);
                Text txtRegistry = new Text(advancedComposite, 2048);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)txtRegistry);
                final Button registryDiscover = new Button(advancedComposite, 8);
                registryDiscover.setText("Discover...");
                registryDiscover.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AdvancedConnectionEditor.this.discoverRegistryPressed(registryDiscover.getShell());
                    }
                });
                GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)registryDiscover);
                UIUtils.setDefaultButtonWidth((Button)registryDiscover);
                AdvancedConnectionEditor.this.registryURLObservable = (IObservableValue)WidgetProperties.text((int)24).observeDelayed(500, (Widget)txtRegistry);
                Binding registryURLBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)AdvancedConnectionEditor.this.registryURLObservable).validatingAfterConvert((IValidator)new URLValidator(AdvancedConnectionEditor.VALIDATOR_URL_TYPE, true))).converting((IConverter)new TrimTrailingSlashConverter())).to(BeanProperties.value((String)"registryURL").observe((Object)AdvancedConnectionEditor.this.model)).in(dbc);
                ControlDecorationSupport.create((ValidationStatusProvider)registryURLBinding, (int)16512);
                Label lblNamespace = new Label(advancedComposite, 0);
                lblNamespace.setText("Cluster namespace:");
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblNamespace);
                Text txtClusterNamespace = new Text(advancedComposite, 2048);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)txtClusterNamespace);
                AdvancedConnectionEditor.this.clusterNamespaceObservable = (IObservableValue)WidgetProperties.text((int)24).observeDelayed(500, (Widget)txtClusterNamespace);
                ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)AdvancedConnectionEditor.this.clusterNamespaceObservable).converting((IConverter)new TrimmingStringConverter())).to(BeanProperties.value((String)"clusterNamespace").observe((Object)AdvancedConnectionEditor.this.model)).in(dbc);
                Link ocWorkspace = new Link(advancedComposite, 8);
                ocWorkspace.setText("<a>Workspace OC Settings</a>");
                GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)ocWorkspace);
                final Button overrideOC = new Button(advancedComposite, 32);
                overrideOC.setText("Override 'oc' location: ");
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblRegistry);
                ISWTObservableValue overrideOCObservable = WidgetProperties.selection().observe((Widget)overrideOC);
                ValueBindingBuilder.bind((IObservableValue)overrideOCObservable).to(BeanProperties.value((String)"ocOverride").observe((Object)AdvancedConnectionEditor.this.model)).in(dbc);
                final Text ocText = new Text(advancedComposite, 2052);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)ocText);
                ISWTObservableValue ocLocationObservable = WidgetProperties.text((int)24).observe((Widget)ocText);
                Binding ocLocationBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ocLocationObservable).converting((IConverter)new TrimmingStringConverter())).to(BeanProperties.value((String)"ocOverrideLocation").observe((Object)AdvancedConnectionEditor.this.model)).in(dbc);
                overrideOCObservable.addValueChangeListener((IValueChangeListener)new IValueChangeListener<Boolean>(){

                    public void handleValueChange(ValueChangeEvent<? extends Boolean> event) {
                        AdvancedConnectionEditor.this.updateOcObservables();
                    }
                });
                ocLocationBinding.getValidationStatus().addValueChangeListener((IValueChangeListener)new IValueChangeListener<IStatus>(){

                    public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
                        AdvancedConnectionEditor.this.updateOcObservables();
                    }
                });
                ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)overrideOCObservable).to((IObservableValue)WidgetProperties.enabled().observe((Widget)ocText)).notUpdatingParticipant()).in(dbc);
                final Button ocBrowse = new Button(advancedComposite, 8);
                ocBrowse.setText("Browse...");
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)ocBrowse);
                UIUtils.setDefaultButtonWidth((Button)ocBrowse);
                ocWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog pd = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.jboss.tools.openshift.ui.preferences.OpenShiftPreferencePage", (String[])new String[0], null);
                        pd.open();
                        if (!overrideOC.getSelection()) {
                            String ocLoc = OpenShiftCorePreferences.INSTANCE.getOCBinaryLocation();
                            String nullsafe = ocLoc == null ? "" : ocLoc;
                            ocText.setText(nullsafe);
                        }
                        AdvancedConnectionEditor.this.updateOcObservables();
                    }
                });
                ocBrowse.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableValue)ocLocationObservable){
                    private final /* synthetic */ IObservableValue val$ocLocationObservable;
                    {
                        this.val$ocLocationObservable = iObservableValue;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        String result;
                        FileDialog fd = new FileDialog(ocBrowse.getShell());
                        fd.setText(ocText.getText());
                        Path p = new Path(ocText.getText());
                        if (p.segmentCount() > 1) {
                            fd.setFilterPath(p.removeLastSegments(1).toOSString());
                        }
                        if ((result = fd.open()) != null) {
                            this.val$ocLocationObservable.setValue((Object)result);
                        }
                    }
                });
                ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)overrideOCObservable).to((IObservableValue)WidgetProperties.enabled().observe((Widget)ocBrowse)).notUpdatingParticipant()).in(dbc);
                MultiValidator ocValidator = new MultiValidator((IObservableValue)ocLocationObservable){
                    private final /* synthetic */ IObservableValue val$ocLocationObservable;
                    {
                        this.val$ocLocationObservable = iObservableValue;
                    }

                    public IObservableList getTargets() {
                        WritableList targets = new WritableList();
                        targets.add((Object)this.val$ocLocationObservable);
                        targets.add((Object)AdvancedConnectionEditor.this.ocLocationValidity);
                        targets.add((Object)AdvancedConnectionEditor.this.ocVersionValidity);
                        return targets;
                    }

                    protected IStatus validate() {
                        IStatus ocLocationStatus = (IStatus)AdvancedConnectionEditor.this.ocLocationValidity.getValue();
                        IStatus ocVersionStatus = (IStatus)AdvancedConnectionEditor.this.ocVersionValidity.getValue();
                        IStatus status = !ocLocationStatus.isOK() ? ocLocationStatus : ocVersionStatus;
                        return status;
                    }
                };
                dbc.addValidationStatusProvider((ValidationStatusProvider)ocValidator);
                ControlDecorationSupport.create((ValidationStatusProvider)ocValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
            }

            protected GridLayoutFactory adjustAdvancedCompositeLayout(GridLayoutFactory gridLayoutFactory) {
                return gridLayoutFactory.numColumns(3);
            }
        };
        part.createAdvancedGroup(composite, 1);
        this.connectionAdvancedPropertiesProvider = new ConnectionAdvancedPropertiesProvider();
        this.updateOcObservables();
        return composite;
    }

    private void updateOcObservables() {
        boolean override = this.model.getOcOverride();
        String location = override ? this.model.getOcOverrideLocation() : OpenShiftCorePreferences.INSTANCE.getOCBinaryLocation();
        this.updateOcObservables(location, override);
    }

    private void updateOcObservables(String location, boolean override) {
        IStatus ocLocationStatus = this.validateOCLocation(location, override);
        this.ocLocationValidity.setValue((Object)ocLocationStatus);
        if (ocLocationStatus.isOK()) {
            this.ocVersionValidity.setValue((Object)ValidationStatus.cancel((String)"Verifying oc version..."));
            final OCVersionValidationJob job = new OCVersionValidationJob(this.model.getOcOverrideLocation());
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    AdvancedConnectionEditor.this.ocVersionValidity.getRealm().exec(() -> AdvancedConnectionEditor.this.ocVersionValidity.setValue((Object)job.getOCVersionValidity()));
                }
            });
            job.schedule();
        }
    }

    private void discoverRegistryPressed(Shell shell) {
        IConnection tmp = this.pageModel.createConnection();
        IStatus ret = RegistryProviderModel.getDefault().getRegistryURL(tmp);
        String oldVal = (String)this.registryURLObservable.getValue();
        String newVal = ret.getMessage();
        if (ret != null && ret.isOK()) {
            if (!this.eq(oldVal, newVal)) {
                String title = "Overwrite registry URL?";
                String msg = "Are you sure you want to change the registry URL from " + oldVal + " to " + newVal + "?";
                MessageDialog dialog = new MessageDialog(shell, title, null, msg, 5, new String[]{"OK", "Cancel"}, 0);
                String old = this.registryURLObservable.getValue().toString().trim();
                if (old.isEmpty() || dialog.open() == 0) {
                    this.registryURLObservable.setValue((Object)ret.getMessage());
                }
            }
        } else {
            String title = "Registry URL not found";
            String msg = "No registry provider found for the given connection. If your Openshift connection is backed by a CDK or minishift installation, please ensure the CDK is running.";
            ErrorDialog ed = new ErrorDialog(shell, title, msg, ret, 15);
            ed.open();
        }
    }

    private boolean eq(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private IStatus validateOCLocation(String location, boolean override) {
        IStatus validity = ValidationStatus.ok();
        if (StringUtils.isBlank((String)location)) {
            validity = override ? ValidationStatus.error((String)"Please provide a location for the OC binary.") : ValidationStatus.error((String)"The workspace setting for the OC binary is not set. Please update the workspace setting or override the location here in the 'Advanced' section.");
        } else {
            File file = new File(location);
            if (override) {
                if (!file.exists()) {
                    validity = ValidationStatus.error((String)NLS.bind((String)"{0} was not found.", (Object)file));
                } else if (file.isDirectory()) {
                    validity = ValidationStatus.error((String)NLS.bind((String)"OC Location must be a file.", (Object)file));
                } else if (!file.canExecute()) {
                    validity = ValidationStatus.error((String)NLS.bind((String)"{0} does not have execute permissions.", (Object)file));
                }
            } else if (!file.exists()) {
                validity = ValidationStatus.error((String)NLS.bind((String)"Workspace setting for OC binary location was not found: {0}", (Object)file));
            } else if (file.isDirectory()) {
                validity = ValidationStatus.error((String)NLS.bind((String)"Workspace setting for OC binary location is not a file: {0}", (Object)file));
            } else if (!file.canExecute()) {
                validity = ValidationStatus.error((String)NLS.bind((String)"Workspace setting for OC binary location does not have execute permissions: {0}", (Object)file));
            }
        }
        return validity;
    }

    protected void onSelectedConnectionChanged(IObservableValue selectedConnection) {
        this.registryURLObservable.setValue((Object)this.model.getRegistryURL());
    }

    public void onVisible(IObservableValue detailViewModel, DataBindingContext dbc) {
        this.pageModel.setConnectionAdvancedPropertiesProvider(this.connectionAdvancedPropertiesProvider);
        this.connectionChangedListener = this.addSelectedConnectionChangedListener(this.selectedConnection, dbc);
    }

    public void onInVisible(IObservableValue detailViewModel, DataBindingContext dbc) {
        this.pageModel.setConnectionAdvancedPropertiesProvider(null);
        this.removeConnectionChangedListener(this.connectionChangedListener, this.selectedConnection);
        this.connectionChangedListener = null;
    }

    private IValueChangeListener addSelectedConnectionChangedListener(final IObservableValue selectedConnection, final DataBindingContext dbc) {
        IValueChangeListener listener = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AdvancedConnectionEditor.this.onSelectedConnectionChanged(selectedConnection);
                DataBindingUtils.validateTargetsToModels((DataBindingContext)dbc);
            }
        };
        selectedConnection.addValueChangeListener(listener);
        return listener;
    }

    private void removeConnectionChangedListener(IValueChangeListener connectionChangedListener, IObservableValue selectedConnection) {
        if (selectedConnection == null || selectedConnection.isDisposed() || connectionChangedListener == null) {
            return;
        }
        selectedConnection.removeValueChangeListener(connectionChangedListener);
    }

    public boolean isViewFor(Object object) {
        return object instanceof ConnectionFactory;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties != null) {
            return this.extendedProperties;
        }
        IConnection connection = this.pageModel.getSelectedConnection();
        if (connection != null) {
            if (NewConnectionMarker.getInstance() == connection) {
                this.extendedProperties = new HashMap<String, Object>();
            } else if (connection instanceof Connection) {
                this.extendedProperties = ((Connection)connection).getExtendedProperties();
            }
            return this.extendedProperties;
        }
        return null;
    }

    public void saveChanges(ConnectionWizardPageModel pageModel) {
        IConnection c = pageModel.getConnection();
        if (c instanceof Connection && this.getExtendedProperties() != null) {
            ((Connection)c).setExtendedProperties(this.getExtendedProperties());
        }
    }

    class AdvancedConnectionEditorModel
    extends ObservablePojo {
        static final String PROP_REGISTRY_URL = "registryURL";
        static final String PROP_CLUSTER_NAMESPACE = "clusterNamespace";
        static final String PROP_OC_OVERRIDE = "ocOverride";
        static final String PROP_OC_OVERRIDE_LOCATION = "ocOverrideLocation";

        AdvancedConnectionEditorModel() {
        }

        public void setOcOverride(boolean value) {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                Object old = properties.get("org.jbosstools.openshift.core.connection.ext.oc.override");
                properties.put("org.jbosstools.openshift.core.connection.ext.oc.override", value);
                this.firePropertyChange(PROP_OC_OVERRIDE, old, value);
            }
        }

        public boolean getOcOverride() {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                return (Boolean)ObjectUtils.defaultIfNull((Object)properties.get("org.jbosstools.openshift.core.connection.ext.oc.override"), (Object)false);
            }
            return false;
        }

        public void setOcOverrideLocation(String value) {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                Object old = properties.get("org.jbosstools.openshift.core.connection.ext.oc.location");
                properties.put("org.jbosstools.openshift.core.connection.ext.oc.location", value);
                this.firePropertyChange(PROP_OC_OVERRIDE_LOCATION, old, value);
            }
        }

        public String getOcOverrideLocation() {
            Map<String, Object> properties;
            if (this.getOcOverride() && (properties = AdvancedConnectionEditor.this.getExtendedProperties()) != null) {
                return (String)ObjectUtils.defaultIfNull((Object)properties.get("org.jbosstools.openshift.core.connection.ext.oc.location"), (Object)"");
            }
            return OpenShiftCorePreferences.INSTANCE.getOCBinaryLocation();
        }

        public void setRegistryURL(String value) {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                Object old = properties.get("org.jbosstools.openshift.core.connection.ext.registry.url");
                properties.put("org.jbosstools.openshift.core.connection.ext.registry.url", value);
                this.firePropertyChange(PROP_REGISTRY_URL, old, value);
            }
        }

        public String getRegistryURL() {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                return (String)ObjectUtils.defaultIfNull((Object)properties.get("org.jbosstools.openshift.core.connection.ext.registry.url"), (Object)"");
            }
            return "";
        }

        public void setClusterNamespace(String value) {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                Object old = properties.get("org.jbosstools.openshift.core.connection.ext.cluster.namespace");
                properties.put("org.jbosstools.openshift.core.connection.ext.cluster.namespace", value);
                this.firePropertyChange(PROP_CLUSTER_NAMESPACE, old, value);
            }
        }

        public String getClusterNamespace() {
            Map<String, Object> properties = AdvancedConnectionEditor.this.getExtendedProperties();
            if (properties != null) {
                return (String)properties.getOrDefault("org.jbosstools.openshift.core.connection.ext.cluster.namespace", "openshift");
            }
            return "openshift";
        }
    }

    private class ConnectionAdvancedPropertiesProvider
    implements ConnectionWizardPageModel.IConnectionAdvancedPropertiesProvider {
        private ConnectionAdvancedPropertiesProvider() {
        }

        public IConnection update(IConnection conn) {
            Assert.isLegal((boolean)(conn instanceof Connection));
            final Connection connection = (Connection)conn;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    connection.setExtendedProperty("org.jbosstools.openshift.core.connection.ext.registry.url", AdvancedConnectionEditor.this.registryURLObservable.getValue());
                    connection.setExtendedProperty("org.jbosstools.openshift.core.connection.ext.cluster.namespace", AdvancedConnectionEditor.this.clusterNamespaceObservable.getValue());
                }
            });
            return connection;
        }
    }

    private class OCVersionValidationJob
    extends Job {
        private Version version;
        private String location;
        private IStatus ocVersionValidity;

        public OCVersionValidationJob(String location) {
            super("Checking oc binary...");
            this.ocVersionValidity = ValidationStatus.cancel((String)"OC version not verified yet.");
            this.location = location;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.version = new OCBinaryVersionValidator(this.location).getVersion(monitor);
            this.ocVersionValidity = Version.emptyVersion.equals((Object)this.version) ? ValidationStatus.error((String)"Could not determine your OpenShift client version") : (!OCBinaryVersionValidator.isCompatibleForPublishing((Version)this.version) ? ValidationStatus.error((String)NLS.bind((String)"OpenShift client version 1.1.1 or higher is required to avoid rsync issues.", (Object)this.version)) : ValidationStatus.ok());
            if (monitor.isCanceled()) {
                this.ocVersionValidity = ValidationStatus.cancel((String)"OC version verification was cancelled.");
            }
            return Status.OK_STATUS;
        }

        public IStatus getOCVersionValidity() {
            return this.ocVersionValidity;
        }
    }
}

