/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;

public class ConnectionValidatorFactory {
    public static MultiValidator createBasicAuthenticationValidator(final ConnectionWizardPageModel pageModel, final IObservableValue usernameObservable, final IObservableValue<?> urlObservable) {
        return new MultiValidator(){

            protected IStatus validate() {
                String user1 = (String)usernameObservable.getValue();
                String mHost = (String)urlObservable.getValue();
                IConnection current = pageModel.getSelectedConnection();
                for (Connection c : ConnectionsRegistrySingleton.getInstance().getAll(Connection.class)) {
                    if (c == current || !"Basic".equals(c.getAuthScheme())) continue;
                    String host = c.getHost();
                    String user = c.getUsername();
                    if (host == null || !host.equals(mHost) || user == null || !user.equals(user1)) continue;
                    return ValidationStatus.error((String)"Connection for the server with this username already exists.");
                }
                return ValidationStatus.ok();
            }
        };
    }

    public static MultiValidator createOAuthAuthenticationValidator(final ConnectionWizardPageModel pageModel, final IObservableValue tokenObservable, final IObservableValue<?> urlObservable) {
        return new MultiValidator(){

            protected IStatus validate() {
                String token1 = (String)tokenObservable.getValue();
                String mHost = (String)urlObservable.getValue();
                IConnection current = pageModel.getSelectedConnection();
                for (Connection c : ConnectionsRegistrySingleton.getInstance().getAll(Connection.class)) {
                    if (c == current || !"OAuth".equals(c.getAuthScheme())) continue;
                    String host = c.getHost();
                    String token = c.getToken();
                    if (host == null || !host.equals(mHost) || token == null || !token.equals(token1)) continue;
                    return ValidationStatus.error((String)"Connection for the server with this token already exists.");
                }
                return ValidationStatus.ok();
            }
        };
    }
}

