/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredStringValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.detailviews.BaseDetailsView;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.connection.ConnectionValidatorFactory;
import org.jboss.tools.openshift.internal.ui.wizard.connection.IConnectionEditorDetailView;

public class OAuthDetailView
extends BaseDetailsView
implements IConnectionEditorDetailView {
    private static final String MSG_TOKEN = "Enter a token or <a>retrieve</a> a new one.";
    private IObservableValue<String> tokenObservable;
    private Binding tokenBinding;
    private Text tokenText;
    private IValueChangeListener<?> changeListener;
    private IObservableValue<Boolean> rememberTokenObservable;
    private IObservableValue<String> authSchemeObservable;
    private IAuthorizationDetails authDetails;
    private ConnectionWizardPageModel pageModel;
    IObservableValue<String> urlObservable;
    private Button rememberTokenCheckbox;
    private Binding rememberTokenBinding;
    private MultiValidator connectionValidator;
    private IWizard wizard;

    public OAuthDetailView(IWizard wizard, ConnectionWizardPageModel pageModel, IValueChangeListener<?> changeListener, Object context, IObservableValue<String> authSchemeObservable) {
        this.wizard = wizard;
        this.pageModel = pageModel;
        this.urlObservable = BeanProperties.value((String)"host").observe((Object)pageModel);
        this.tokenObservable = new WritableValue(null, String.class);
        this.rememberTokenObservable = new WritableValue((Object)Boolean.FALSE, Boolean.class);
        this.connectionValidator = ConnectionValidatorFactory.createOAuthAuthenticationValidator(pageModel, this.tokenObservable, this.urlObservable);
        this.authSchemeObservable = authSchemeObservable;
        this.changeListener = changeListener;
        if (context instanceof IAuthorizationDetails) {
            this.authDetails = (IAuthorizationDetails)context;
        }
    }

    IObservableValue<Boolean> getRememberTokenObservable() {
        return this.rememberTokenObservable;
    }

    public final Text getTokenTextControl() {
        return this.tokenText;
    }

    public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 10).applyTo(composite);
        StyledText tokenRequestLink = StyledTextUtils.emulateLinkWidget((String)MSG_TOKEN, (StyledText)new StyledText(composite, 64));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)tokenRequestLink);
        if (this.authDetails != null) {
            this.authDetails.getRequestTokenLink();
        }
        StyledTextUtils.emulateLinkAction((StyledText)tokenRequestLink, r -> this.onRetrieveLinkClicked(tokenRequestLink.getShell(), dbc));
        tokenRequestLink.setCursor(new Cursor((Device)tokenRequestLink.getShell().getDisplay(), 21));
        Label authTypeLabel = new Label(composite, 0);
        authTypeLabel.setText("Token");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)authTypeLabel);
        this.tokenText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.tokenText);
        ControlDecorationSupport.create((ValidationStatusProvider)this.connectionValidator, (int)16512, null, (ControlDecorationUpdater)new ControlDecorationUpdater());
        this.rememberTokenCheckbox = new Button(composite, 32);
        this.rememberTokenCheckbox.setText("&Save token (could trigger secure storage login)");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.rememberTokenCheckbox);
        return composite;
    }

    public void onVisible(IObservableValue detailsViewModel, DataBindingContext dbc) {
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.connectionValidator);
        this.bindWidgetsToInternalModel(dbc);
        this.rememberTokenBinding = ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)this.rememberTokenCheckbox)).to(this.rememberTokenObservable).in(dbc);
    }

    public void onInVisible(IObservableValue detailsViewModel, DataBindingContext dbc) {
        this.dispose();
        org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils.dispose((ValidationStatusProvider)this.rememberTokenBinding);
        dbc.removeValidationStatusProvider((ValidationStatusProvider)this.connectionValidator);
    }

    public void dispose() {
        org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils.dispose((ValidationStatusProvider)this.tokenBinding);
    }

    private void bindWidgetsToInternalModel(DataBindingContext dbc) {
        RequiredStringValidator validator = new RequiredStringValidator("token");
        this.tokenBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tokenText)).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)validator)).to(this.tokenObservable).validatingBeforeSet((IValidator)validator)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.tokenBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        DataBindingUtils.addDisposableValueChangeListener(this.changeListener, this.tokenObservable, (Control)this.tokenText);
    }

    @Override
    public void setSelectedConnection(IConnection selectedConnection) {
        if (selectedConnection instanceof Connection) {
            Connection connection = (Connection)selectedConnection;
            this.tokenObservable.setValue((Object)connection.getToken());
            this.rememberTokenObservable.setValue((Object)connection.isRememberToken());
        } else if (selectedConnection instanceof NewConnectionMarker) {
            this.tokenObservable.setValue(null);
            this.rememberTokenObservable.setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public ConnectionWizardPageModel.IConnectionAuthenticationProvider getConnectionAuthenticationProvider() {
        return new BearTokenAuthenticationProvider();
    }

    public boolean isViewFor(Object object) {
        return object == this;
    }

    public String toString() {
        return "OAuth";
    }

    private void onRetrieveLinkClicked(Shell shell, DataBindingContext dbc) {
        if (StringUtils.isBlank((String)this.pageModel.getHost())) {
            return;
        }
        try {
            WizardUtils.runInWizard((Job)this.createAuthDetailsJob(shell), (IWizardContainer)this.wizard.getContainer(), (DataBindingContext)dbc);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            this.showErrorDialog(shell, ex);
        }
    }

    protected Job createAuthDetailsJob(final Shell shell) {
        AuthDetailsJob job = new AuthDetailsJob(this.pageModel.getHost());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                if (event.getJob() instanceof AuthDetailsJob) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AuthDetailsJob job = (AuthDetailsJob)event.getJob();
                            IAuthorizationDetails details = job.getDetails();
                            if (details != null) {
                                if ("Basic".equals(details.getScheme())) {
                                    MessageDialog.openError((Shell)shell, (String)"Authorization Information", (String)NLS.bind((String)"This server utilizes {0} authorization protocol", (Object)details.getScheme()));
                                    OAuthDetailView.this.authSchemeObservable.setValue((Object)details.getScheme());
                                } else {
                                    OAuthDialog dialog = new OAuthDialog(shell, details.getRequestTokenLink());
                                    dialog.open();
                                    String token = dialog.getToken();
                                    if (StringUtils.isNotBlank((String)token)) {
                                        OAuthDetailView.this.tokenObservable.setValue((Object)token);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
        return job;
    }

    private void showErrorDialog(final Shell shell, final Throwable e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)shell, (String)"Request Authentication Details Error", (String)"Unable to retrieve authentication details", (IStatus)ValidationStatus.error((String)e.getMessage(), (Throwable)e));
            }
        });
    }

    private class AuthDetailsJob
    extends Job {
        private IAuthorizationDetails details;
        private String host;

        public AuthDetailsJob(String host) {
            super(NLS.bind((String)"Retrieve authorization details from {0}...", (Object)host));
            this.host = host;
        }

        public IAuthorizationDetails getDetails() {
            return this.details;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IClient client = new ClientBuilder(this.host).sslCertificateCallback(OpenShiftCoreUIIntegration.getInstance().getSSLCertificateCallback()).build();
                this.details = client.getAuthorizationContext().getAuthorizationDetails();
                return ValidationStatus.OK_STATUS;
            }
            catch (Exception e) {
                if (e.getCause() instanceof ConnectTimeoutException) {
                    return new Status(4, "org.jboss.tools.openshift.ui", "Timed out waiting for a response for authorization details.\nThis server might be unavailable or may not support OAuth.", (Throwable)e);
                }
                return new Status(4, "org.jboss.tools.openshift.ui", "Unable to retrieve the authentication details", (Throwable)e);
            }
        }
    }

    private class BearTokenAuthenticationProvider
    implements ConnectionWizardPageModel.IConnectionAuthenticationProvider {
        private BearTokenAuthenticationProvider() {
        }

        public IConnection update(IConnection conn) {
            Assert.isLegal((boolean)(conn instanceof Connection));
            final Connection connection = (Connection)conn;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    connection.setAuthScheme("OAuth");
                    connection.setToken((String)OAuthDetailView.this.tokenObservable.getValue());
                    connection.setRememberToken(((Boolean)OAuthDetailView.this.rememberTokenObservable.getValue()).booleanValue());
                }
            });
            return connection;
        }
    }

    private class OAuthDialog
    extends Dialog {
        private String loadingHtml;
        private String url;
        private Browser browser;
        private String token;

        OAuthDialog(Shell parentShell, String url) {
            super(parentShell);
            this.url = url;
            try {
                this.loadingHtml = IOUtils.toString((InputStream)OpenShiftUIActivator.getDefault().getPluginFile("html/spinner.html"));
            }
            catch (Exception exception) {
                this.loadingHtml = "Loading...";
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Close", true);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Point getInitialSize() {
            return new Point(500, 700);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
            this.browser = new Browser(container, 2048);
            this.browser.setText(this.loadingHtml);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.browser);
            final ProgressBar progressBar = new ProgressBar(container, 0);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)progressBar);
            ProgressListener progressListener = new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total <= 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    progressBar.setSelection(ratio);
                }

                public void completed(ProgressEvent event) {
                    progressBar.setSelection(0);
                    TokenExtractor extractor = new TokenExtractor(OAuthDialog.this.browser.getText());
                    if (extractor.isTokenPage()) {
                        OAuthDialog.this.token = extractor.getToken();
                    }
                }
            };
            this.browser.addProgressListener(progressListener);
            this.setURL(this.url);
            return container;
        }

        public void setURL(String url) {
            if (StringUtils.isNotBlank((String)url)) {
                this.url = url;
                this.browser.setUrl(url);
            }
        }

        public String getToken() {
            return this.token;
        }
    }

    public static class TokenExtractor {
        public static final Pattern TOKEN_PAGE_PATTERN = Pattern.compile(".*<h2>Your API token is<\\/h2>.*<code>(.*)<\\/code>.*", 32);
        private Matcher matcher;

        public TokenExtractor(String content) {
            this.matcher = TOKEN_PAGE_PATTERN.matcher(content);
        }

        public boolean isTokenPage() {
            return this.matcher.matches();
        }

        public String getToken() {
            return this.matcher.group(1);
        }
    }
}

