/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariablePage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeploymentConfigPageModel;

public class DeploymentConfigPage
extends EnvironmentVariablePage {
    public static final String PAGE_NAME = "Deployment Config Settings Page";
    private static final String PAGE_TITLE = "Deployment Configuration && Scalability";
    private static final String PAGE_DESCRIPTION = "";
    private IDeploymentConfigPageModel model;
    private TableViewer dataViewer;
    private Composite volTableContainer;

    public DeploymentConfigPage(IWizard wizard, IDeploymentConfigPageModel model) {
        super(PAGE_TITLE, PAGE_DESCRIPTION, PAGE_NAME, wizard, model);
        this.model = model;
    }

    protected void doCreateControls(final Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        this.createEnvVariableControl(parent, dbc, "Deployment environment variables (Runtime only):", "Environment variables are passed to running pods for consumption by the pod containers");
        Label separator1 = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)separator1);
        this.createDataVolumeControl(parent, dbc);
        Label separator2 = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)separator2);
        Composite scalingContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scalingContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(scalingContainer);
        Label lblReplicas = new Label(scalingContainer, 0);
        lblReplicas.setText("Replicas:");
        lblReplicas.setToolTipText("Replicas are the number of copies of an image that will be scheduled to run on OpenShift");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblReplicas);
        Spinner replicas = new Spinner(scalingContainer, 2048);
        replicas.setMinimum(1);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)replicas);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)replicas)).to(BeanProperties.value((String)"replicas").observe((Object)this.model)).in(dbc);
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (parent.isDisposed() || DeploymentConfigPage.this.envTableContainer == null || DeploymentConfigPage.this.envTableContainer.isDisposed() || DeploymentConfigPage.this.volTableContainer == null || DeploymentConfigPage.this.volTableContainer.isDisposed()) {
                    return;
                }
                int h = parent.getSize().y;
                if (h > 0) {
                    int envtable = DeploymentConfigPage.this.heightScale * 5 + 30;
                    int voltable = DeploymentConfigPage.this.heightScale * 4 + 24;
                    int replicas = DeploymentConfigPage.this.heightScale * 7;
                    int all = envtable + voltable + replicas;
                    int minVolume = DeploymentConfigPage.this.heightScale * 2;
                    int hEnvVar = envtable;
                    int hVolumes = voltable;
                    if (h > all) {
                        hEnvVar = (h - replicas) * envtable / (envtable + voltable);
                        hVolumes = (h - replicas) * voltable / (envtable + voltable);
                    } else {
                        hVolumes = h > envtable + replicas + minVolume ? h - envtable - replicas : minVolume;
                    }
                    ((GridData)((DeploymentConfigPage)DeploymentConfigPage.this).envTableContainer.getLayoutData()).heightHint = hEnvVar;
                    ((GridData)((DeploymentConfigPage)DeploymentConfigPage.this).volTableContainer.getLayoutData()).heightHint = hVolumes;
                    parent.layout(true);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createDataVolumeControl(Composite parent, DataBindingContext dbc) {
        Composite sectionContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)sectionContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(sectionContainer);
        Label lblSection = new Label(sectionContainer, 0);
        lblSection.setText("Data volumes:");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).applyTo((Control)lblSection);
        Composite tableContainer = this.volTableContainer = new Composite(sectionContainer, 0);
        this.dataViewer = this.createDataVolumeTable(tableContainer);
        this.dataViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        GridDataFactory.fillDefaults().span(2, 4).align(4, 4).grab(true, false).hint(-1, 150).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.dataViewer)).to(BeanProperties.value((String)"selectedVolume").observe((Object)this.model));
        this.dataViewer.setInput((Object)BeanProperties.list((String)"volumes").observe((Object)this.model));
        Label lblNotice = new Label(sectionContainer, 64);
        lblNotice.setText(NLS.bind((String)"NOTICE: This image might use an EmptyDir volume. Data in EmptyDir volumes is not persisted across deployments.", (Object)this.model.getResourceName()));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 2).applyTo((Control)lblNotice);
    }

    protected TableViewer createDataVolumeTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.dataViewer = new TableViewerBuilder(table, tableContainer).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<String>(){

            public String getValue(String label) {
                return label;
            }
        }).name("Container Path").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        this.dataViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String first = (String)e1;
                String other = (String)e2;
                return first.compareTo(other);
            }
        });
        return this.dataViewer;
    }
}

