/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.internal.core.docker.DockerImageUtils;

public class ListDockerImagesWizardModel
extends ObservablePojo {
    private final IDockerConnection dockerConnection;
    public static final String FILTER_NAME = "filterName";
    public static final String DOCKER_IMAGES = "dockerImages";
    public static final String SELECTED_DOCKER_IMAGE = "selectedDockerImage";
    private String filterName;
    private List<DockerImageTag> dockerImages;
    private DockerImageTag selectedDockerImage;

    public ListDockerImagesWizardModel(IDockerConnection dockerConnection, String imageName) {
        this.dockerConnection = dockerConnection;
        this.filterName = imageName;
    }

    public IDockerConnection getDockerConnection() {
        return this.dockerConnection;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setImageName(String filterName) {
        this.filterName = filterName;
        this.firePropertyChange(FILTER_NAME, this.filterName, this.filterName);
    }

    public List<DockerImageTag> getDockerImages() {
        return this.dockerImages;
    }

    public void setDockerImages(List<IDockerImage> dockerImages) {
        List topLevelImages = dockerImages.stream().filter(image -> !image.isDangling() && !image.isIntermediateImage()).collect(Collectors.toList());
        ArrayList<DockerImageTag> imageTags = new ArrayList<DockerImageTag>();
        for (IDockerImage topLevelImage : topLevelImages) {
            Map repoTags = DockerImageUtils.extractTagsByRepo((List)topLevelImage.repoTags());
            for (Map.Entry entry : repoTags.entrySet()) {
                String repo = (String)entry.getKey();
                List tags = (List)entry.getValue();
                for (String tag : tags) {
                    imageTags.add(new DockerImageTag(topLevelImage.id(), repo, tag));
                }
            }
        }
        Collections.sort(imageTags, new Comparator<DockerImageTag>(){

            @Override
            public int compare(DockerImageTag image1, DockerImageTag image2) {
                return image1.getRepoName().compareTo(image2.getRepoName());
            }
        });
        this.dockerImages = imageTags;
        this.firePropertyChange(DOCKER_IMAGES, this.dockerImages, this.dockerImages);
    }

    public DockerImageTag getSelectedDockerImage() {
        return this.selectedDockerImage;
    }

    public void setSelectedDockerImage(DockerImageTag selectedDockerImage) {
        this.selectedDockerImage = selectedDockerImage;
        this.firePropertyChange(SELECTED_DOCKER_IMAGE, this.selectedDockerImage, this.selectedDockerImage);
    }

    static class DockerImageTag {
        private final String id;
        private final String repoName;
        private final String tag;

        public DockerImageTag(String id, String repoName, String tag) {
            this.id = id.startsWith("sha256:") ? id.substring("sha256:".length(), "sha256:".length() + 12) : id.substring(0, 12);
            this.repoName = repoName;
            this.tag = tag;
        }

        public String getId() {
            return this.id;
        }

        public String getRepoName() {
            return this.repoName;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

