/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IServicePort;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class PodPortValidator
implements IValidator {
    private static final int POD_PORT_MAXLENGTH = 63;
    private static final Pattern POD_PORT_REGEXP = Pattern.compile("[a-z0-9]([a-z0-9-]*[a-z0-9])*");
    private static final IStatus POD_PORT_FORMAT_ERROR_STATUS = ValidationStatus.error((String)"The Pod port must be a unique integer\nor a name matching [a-z0-9]([a-z0-9-]*[a-z0-9])*");
    private static final IStatus CANCEL_STATUS = ValidationStatus.cancel((String)"The Pod port must be a unique integer\nor the name of a port in the backend pods.");
    private static final IStatus POD_PORT_UNIQUE_ERROR_STATUS = ValidationStatus.error((String)NLS.bind((String)"The {0} port number must be unique among all the other ports exposed by this OpenShift service.", (Object)"pod"));
    private static final IStatus POD_PORT_LENGTH_ERROR_STATUS = ValidationStatus.error((String)"Pod port name exceeds the maximum length 63");
    private static final IStatus POD_PORT_INTERVAL_ERROR_STATUS = ValidationStatus.error((String)"Pod port number is out of valid interval from 0 to 65535");
    private final String podPort;
    private final List<IServicePort> ports;

    public PodPortValidator(String podPort, List<IServicePort> ports) {
        this.podPort = podPort;
        this.ports = ports;
    }

    public IStatus validate(Object value) {
        if (StringUtils.isEmpty((Object)value)) {
            return CANCEL_STATUS;
        }
        String newPodPort = (String)value;
        if (!newPodPort.equals(this.podPort)) {
            block7: {
                try {
                    long portNumber = Long.valueOf(value.toString());
                    if (portNumber < 0L || portNumber > 65535L) {
                        return POD_PORT_INTERVAL_ERROR_STATUS;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (newPodPort.length() > 63) {
                        return POD_PORT_LENGTH_ERROR_STATUS;
                    }
                    if (POD_PORT_REGEXP.matcher(newPodPort).matches()) break block7;
                    return POD_PORT_FORMAT_ERROR_STATUS;
                }
            }
            for (IServicePort port : this.ports) {
                if (!newPodPort.equals(port.getTargetPort())) continue;
                return POD_PORT_UNIQUE_ERROR_STATUS;
            }
        }
        return ValidationStatus.OK_STATUS;
    }
}

