/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.internal.core.docker.IDockerImageMetadata;
import org.jboss.tools.openshift.internal.core.docker.ImageStreamTagMetaData;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.CreateApplicationFromImageJob;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModelJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariablesPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.IEnvironmentVariablesPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImageWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSourceModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.IBuildConfigPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.ImageStreamApplicationSource;

public class ApplicationSourceFromImageModel
extends DeployImageWizardModel
implements IApplicationSourceModel,
IBuildConfigPageModel {
    private static final String ANNOTATION_SAMPLE_CONTEXT_DIR = "sampleContextDir";
    private static final String ANNOTATION_SAMPLE_REPO = "sampleRepo";
    private static final String ANNOTATION_SAMPLE_REF = "sampleRef";
    private static final String DEFAULT_REFERENCE = "master";
    private ImageStreamApplicationSource source;
    private org.eclipse.core.resources.IProject eclipseProject;
    private IWizardContainer container;
    private IEnvironmentVariablesPageModel envModel = new EnvironmentVariablesPageModel();
    private String gitRepositoryUrl = "";
    private String gitReference = "master";
    private String contextDir = "";
    private boolean imageChangeTrigger = true;
    private boolean configChangeTrigger = true;
    private boolean configWebHook = true;
    private AtomicBoolean staleRepoInfo = new AtomicBoolean(true);

    @Override
    public IResourcesModelJob createFinishJob() {
        return new CreateApplicationFromImageJob(this, (IDeployImageParameters)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        super.propertyChange(evt);
        switch (evt.getPropertyName()) {
            case "labels": {
                this.setLabels((List)evt.getNewValue());
                break;
            }
            case "selectedAppSource": {
                this.handleSelectedAppSource(evt);
                break;
            }
            case "project": {
                this.setProject((IProject)evt.getNewValue());
                break;
            }
            case "eclipseProject": {
                this.handleEclipseProject(evt);
            }
        }
    }

    private void handleEclipseProject(PropertyChangeEvent evt) {
        this.eclipseProject = (org.eclipse.core.resources.IProject)evt.getNewValue();
        if (this.eclipseProject != null) {
            try {
                this.setGitRepositoryUrl(EGitUtils.getDefaultRemoteRepo((org.eclipse.core.resources.IProject)this.eclipseProject));
                this.setGitReference(EGitUtils.getCurrentBranch((org.eclipse.core.resources.IProject)this.eclipseProject));
                this.setContextDir("");
                return;
            }
            catch (CoreException e) {
                OpenShiftUIActivator.getDefault().getLogger().logWarning("Unable to retrieve the remote git repo from " + this.eclipseProject.getName(), (Throwable)e);
            }
        }
        this.setGitRepositoryUrl(null);
        this.setGitReference(null);
        this.setContextDir(null);
    }

    private void handleSelectedAppSource(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof ImageStreamApplicationSource && "ImageStream".equals(((IApplicationSource)evt.getNewValue()).getKind())) {
            this.source = (ImageStreamApplicationSource)evt.getNewValue();
            this.staleRepoInfo.set(true);
            if (this.eclipseProject == null) {
                this.setGitRepositoryUrl(null);
                this.setGitReference(null);
                this.setContextDir(null);
            }
            this.setResourceName(null);
        }
    }

    @Override
    public void init() {
        if (this.staleRepoInfo.compareAndSet(true, false)) {
            this.loadBuilderImageMetadata();
            if (this.source != null && this.getGitRepositoryUrl() == null) {
                this.setGitRepositoryUrl(this.source.getAnnotation(ANNOTATION_SAMPLE_REPO));
                this.setContextDir(this.source.getAnnotation(ANNOTATION_SAMPLE_CONTEXT_DIR));
                this.setGitReference(this.source.getAnnotation(ANNOTATION_SAMPLE_REF));
            }
        }
    }

    private void loadBuilderImageMetadata() {
        if (this.source != null && this.container != null) {
            this.setImageName(NLS.bind((String)"{0}/{1}", (Object)this.source.getNamespace(), (Object)this.source.getName()));
            Job loadImageJob = new Job("Load builder image metadata..."){

                protected IStatus run(IProgressMonitor monitor) {
                    if (ApplicationSourceFromImageModel.this.initializeContainerInfo()) {
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            try {
                IStatus status = WizardUtils.runInWizard((Job)loadImageJob, (IWizardContainer)this.container);
                if (!status.isOK()) {
                    MessageDialog.openWarning((Shell)this.container.getShell(), (String)"Warning", (String)NLS.bind((String)"No builder image metadata for {0} could be found.", (Object)this.getImageName()));
                }
            }
            catch (InterruptedException | InvocationTargetException e) {
                String message = NLS.bind((String)"Failed to look-up metadata for a builder image {0}", (Object)this.getImageName());
                MessageDialog.openError((Shell)this.container.getShell(), (String)"Error", (String)message);
                OpenShiftUIActivator.getDefault().getLogger().logError(message, (Throwable)e);
            }
        }
    }

    @Override
    protected IDockerImageMetadata lookupImageMetadata() {
        if (this.source == null) {
            return null;
        }
        try {
            Connection conn = ConnectionsRegistryUtil.getConnectionFor((IResource)this.getProject());
            IResource istag = conn.getResource("ImageStreamTag", this.source.getNamespace(), this.source.getName());
            return new ImageStreamTagMetaData(istag.toJson(true));
        }
        catch (Exception e) {
            OpenShiftUIActivator.getDefault().getLogger().logError(NLS.bind((String)"Unable to retrieve imagestream tag for {0}", (Object)this.getImageName()), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getBuilderImageName() {
        return this.source.getName();
    }

    @Override
    public String getBuilderImageNamespace() {
        return this.source.getNamespace();
    }

    public void setContainer(IWizardContainer container) {
        this.container = container;
    }

    @Override
    public IEnvironmentVariablesPageModel getEnvVariablesModel() {
        return this.envModel;
    }

    @Override
    public void setConfigWebHook(boolean value) {
        this.configWebHook = value;
        this.firePropertyChange("configWebHook", this.configWebHook, this.configWebHook);
    }

    @Override
    public boolean isConfigWebHook() {
        return this.configWebHook;
    }

    @Override
    public void setConfigChangeTrigger(boolean value) {
        this.configChangeTrigger = value;
        this.firePropertyChange("configChangeTrigger", this.configChangeTrigger, this.configChangeTrigger);
    }

    @Override
    public boolean isConfigChangeTrigger() {
        return this.configChangeTrigger;
    }

    @Override
    public void setImageChangeTrigger(boolean value) {
        this.imageChangeTrigger = value;
        this.firePropertyChange("imageChangeTrigger", this.imageChangeTrigger, this.imageChangeTrigger);
    }

    @Override
    public boolean isImageChangeTrigger() {
        return this.imageChangeTrigger;
    }

    @Override
    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    @Override
    public void setGitRepositoryUrl(String url) {
        this.gitRepositoryUrl = url;
        this.firePropertyChange("gitRepositoryUrl", this.gitRepositoryUrl, this.gitRepositoryUrl);
    }

    @Override
    public String getGitReference() {
        return this.gitReference;
    }

    @Override
    public void setGitReference(String ref) {
        this.gitReference = ref;
        this.firePropertyChange("gitReference", this.gitReference, this.gitReference);
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public void setContextDir(String contextDir) {
        this.contextDir = contextDir;
        this.firePropertyChange("contextDir", this.contextDir, this.contextDir);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.source = null;
        this.container = null;
        ((EnvironmentVariablesPageModel)this.envModel).dispose();
    }
}

