/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import com.openshift.restclient.model.template.ITemplate;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.internal.ui.job.CreateApplicationFromTemplateJob;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModelJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSourceModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IResourceDetailsModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.ITemplateParametersPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.NewApplicationSummaryFromTemplateDialog;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateParameterViewerUtils;

public class ApplicationSourceFromTemplateModel
extends ResourceLabelsPageModel
implements IResourceDetailsModel,
ITemplateParametersPageModel,
IApplicationSourceModel {
    static final String PROPERTY_MODIFIED_PARAMETER = "modifiedParameter";
    private IProject project;
    private ITemplate template;
    private List<IParameter> parameters = new ArrayList<IParameter>();
    private IParameter selectedParameter;
    private Map<String, String> originalValueMap;
    private Collection<IResource> items = new ArrayList<IResource>();
    private org.eclipse.core.resources.IProject eclipseProject;

    @Override
    public IResourcesModelJob createFinishJob() {
        return new AppFromTemplateJob();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "labels": {
                this.setLabels((List)evt.getNewValue());
                break;
            }
            case "project": {
                this.project = (IProject)evt.getNewValue();
                break;
            }
            case "selectedAppSource": {
                this.handleSelectedAppSource(evt);
                break;
            }
            case "eclipseProject": {
                this.handleEclipseProject(evt);
            }
        }
    }

    private void handleSelectedAppSource(PropertyChangeEvent evt) {
        IApplicationSource source;
        ITemplate newTemplate;
        if (evt.getNewValue() instanceof IApplicationSource && "Template".equals(((IApplicationSource)evt.getNewValue()).getKind()) && !Objects.equals(newTemplate = (ITemplate)(source = (IApplicationSource)evt.getNewValue()).getSource(), this.template)) {
            this.template = newTemplate;
            this.updateTemplateParameters(newTemplate);
        }
    }

    private void handleEclipseProject(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof org.eclipse.core.resources.IProject) {
            this.eclipseProject = (org.eclipse.core.resources.IProject)evt.getNewValue();
            this.updateTemplateParameters(this.template);
        }
    }

    @Override
    public Collection<IResource> getItems() {
        return this.items;
    }

    private void setItems(Collection<IResource> items) {
        this.items = items;
        this.firePropertyChange("items", this.items, this.items);
    }

    private void updateTemplateParameters(ITemplate template) {
        if (template == null) {
            return;
        }
        this.setParameters(template.getParameters().values());
        this.setItems(template.getObjects());
        this.setLabels(template.getObjectLabels());
    }

    @Override
    public List<IParameter> getParameters() {
        return this.parameters;
    }

    public boolean isParameterModified(IParameter param) {
        return param != null && this.originalValueMap != null && !Objects.equals(param.getValue(), this.originalValueMap.get(param.getName()));
    }

    @Override
    public void setParameters(Collection<IParameter> parameters) {
        ArrayList<IParameter> oldParameters = new ArrayList<IParameter>(this.parameters);
        if (parameters == null) {
            this.parameters.clear();
        } else {
            this.originalValueMap = this.toMap(parameters);
            ArrayList<IParameter> newParameters = new ArrayList<IParameter>();
            newParameters.addAll(this.injectProjectParameters(this.eclipseProject, parameters));
            this.parameters.clear();
            this.parameters.addAll(newParameters);
            Collections.sort(this.parameters, new TemplateParameterViewerUtils.ParameterNameComparator());
        }
        this.firePropertyChange("parameters", oldParameters, this.parameters);
        this.setSelectedParameter(this.getSelectedParameterOrDefault());
    }

    private Map<String, String> toMap(Collection<IParameter> parameters) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (parameters != null) {
            parameters.forEach(p -> {
                String string = paramsMap.put(p.getName(), p.getValue());
            });
        }
        return paramsMap;
    }

    private Collection<IParameter> injectProjectParameters(org.eclipse.core.resources.IProject project, Collection<IParameter> originalParameters) {
        if (originalParameters == null || originalParameters.isEmpty()) {
            return originalParameters;
        }
        Map<String, String> projectParams = this.getProjectParameters(project);
        originalParameters = originalParameters.stream().map(p -> {
            String value = (String)projectParams.get(p.getName());
            if (value != null) {
                p = p.clone();
                p.setValue(value);
            }
            return p;
        }).collect(Collectors.toList());
        return originalParameters;
    }

    private Map<String, String> getProjectParameters(org.eclipse.core.resources.IProject project) {
        if (project == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> projectParams = new HashMap<String, String>();
        String gitRepo = this.getGitRepo(project);
        if (gitRepo != null) {
            projectParams.put("SOURCE_REPOSITORY_URL", gitRepo);
            projectParams.put("GIT_URI", gitRepo);
            String branch = this.getGitBranch(project);
            projectParams.put("SOURCE_REPOSITORY_REF", branch);
            projectParams.put("GIT_REF", branch);
            String contextDir = "";
            projectParams.put("CONTEXT_DIR", contextDir);
            projectParams.put("GIT_CONTEXT_DIR", contextDir);
        }
        return projectParams;
    }

    private String getGitBranch(org.eclipse.core.resources.IProject project) {
        try {
            return StringUtils.defaultString((String)EGitUtils.getCurrentBranch((org.eclipse.core.resources.IProject)project));
        }
        catch (CoreException e) {
            throw new OpenShiftException((Throwable)e, NLS.bind((String)"Could not determine the default Git branch for \"{0}\"", (Object)project.getName()), new Object[0]);
        }
    }

    private String getGitRepo(org.eclipse.core.resources.IProject project) {
        try {
            return StringUtils.defaultString((String)EGitUtils.getDefaultRemoteRepo((org.eclipse.core.resources.IProject)project));
        }
        catch (CoreException e) {
            throw new OpenShiftException((Throwable)e, NLS.bind((String)"Could not determine the default remote Git repository for \"{0}\"", (Object)project.getName()), new Object[0]);
        }
    }

    @Override
    public IParameter getSelectedParameter() {
        return this.selectedParameter;
    }

    private IParameter getSelectedParameterOrDefault() {
        if (this.selectedParameter == null || !this.parameters.contains(this.selectedParameter)) {
            if (CollectionUtils.isEmpty(this.parameters)) {
                return null;
            }
            return this.parameters.get(0);
        }
        return this.selectedParameter;
    }

    @Override
    public void setSelectedParameter(IParameter parameter) {
        this.selectedParameter = parameter;
        this.firePropertyChange("selectedParameter", this.selectedParameter, this.selectedParameter);
    }

    @Override
    public void updateParameterValue(IParameter param, String value) {
        param.setValue(value);
        this.firePropertyChange(PROPERTY_MODIFIED_PARAMETER, null, param);
        IParameter s = this.selectedParameter;
        this.setSelectedParameter(null);
        this.setSelectedParameter(s);
    }

    @Override
    public void resetParameter(IParameter param) {
        if (param != null && !Objects.equals(param.getValue(), this.originalValueMap.get(param.getName()))) {
            this.updateParameterValue(param, this.originalValueMap.get(param.getName()));
        }
    }

    private void setLabels(Map<String, String> labelMap) {
        if (labelMap == null) {
            return;
        }
        ArrayList<IResourceLabelsPageModel.Label> labels = new ArrayList<IResourceLabelsPageModel.Label>(labelMap.size());
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            labels.add(new IResourceLabelsPageModel.Label(entry.getKey(), entry.getValue()));
        }
        this.setLabels(labels);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.project = null;
        this.template = null;
        this.parameters.clear();
        this.selectedParameter = null;
        if (this.originalValueMap != null) {
            this.originalValueMap.clear();
        }
        this.items.clear();
        this.eclipseProject = null;
    }

    class AppFromTemplateJob
    implements IResourcesModelJob {
        private final CreateApplicationFromTemplateJob job;

        AppFromTemplateJob() {
            this.job = new CreateApplicationFromTemplateJob(ApplicationSourceFromTemplateModel.this.project, ApplicationSourceFromTemplateModel.this.template, ApplicationSourceFromTemplateModel.this.getParameters(), ApplicationSourceFromTemplateModel.this.getLabels());
        }

        @Override
        public Collection<IResource> getResources() {
            return this.job.getResources();
        }

        @Override
        public Runnable getSummaryRunnable(final Shell shell) {
            return new Runnable(){

                @Override
                public void run() {
                    String message = NLS.bind((String)"Results of creating the resources from the {0} template.", (Object)ApplicationSourceFromTemplateModel.this.template.getName());
                    new NewApplicationSummaryFromTemplateDialog(shell, AppFromTemplateJob.this.job, message).open();
                }
            };
        }

        @Override
        public Job getJob() {
            return this.job;
        }

        @Override
        public DelegatingProgressMonitor getDelegatingProgressMonitor() {
            return this.job.getDelegatingProgressMonitor();
        }

        @Override
        public void addJobChangeListener(IJobChangeListener listener) {
            this.job.addJobChangeListener(listener);
        }
    }
}

