/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.ITags;
import com.openshift.restclient.model.template.ITemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IApplicationSource;

public class TemplateApplicationSource
implements IApplicationSource {
    private final ITemplate template;

    public TemplateApplicationSource(ITemplate template) {
        if (template == null) {
            throw new OpenShiftException("ITemplate instance was null while trying to Instantiate a %s", new Object[]{TemplateApplicationSource.class});
        }
        this.template = template;
    }

    @Override
    public String getName() {
        return this.template.getName();
    }

    @Override
    public String getNamespace() {
        return this.template.getNamespace();
    }

    public ITemplate getSource() {
        return this.template;
    }

    @Override
    public String getKind() {
        return this.template.getKind();
    }

    @Override
    public Collection<String> getTags() {
        return (Collection)this.template.accept((CapabilityVisitor)new CapabilityVisitor<ITags, Collection<String>>(){

            public Collection<String> visit(ITags capability) {
                return capability.getTags();
            }
        }, Collections.emptyList());
    }

    @Override
    public boolean isAnnotatedWith(String key) {
        return this.template.isAnnotatedWith(key);
    }

    @Override
    public String getAnnotation(String key) {
        return this.template.getAnnotation(key);
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.template.getAnnotations();
    }
}

