/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate;

import com.openshift.restclient.model.template.IParameter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;

public class TemplateParameterDetailViews
extends AbstractStackedDetailViews {
    private final AbstractStackedDetailViews.IDetailView parameterView = new ParameterView();

    TemplateParameterDetailViews(IObservableValue parameterObservable, Composite parent, DataBindingContext dbc) {
        super(parameterObservable, null, parent, dbc);
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.parameterView.createControls(parent, context, dbc);
        this.emptyView.createControls(parent, context, dbc);
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.emptyView, this.parameterView};
    }

    private class ParameterView
    extends AbstractStackedDetailViews.EmptyView {
        private StyledText nameText;
        private StyledText descriptionText;

        private ParameterView() {
            super((AbstractStackedDetailViews)TemplateParameterDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(super.createControls(parent, context, dbc));
            GridLayoutFactory.fillDefaults().margins(8, 2).spacing(6, 2).applyTo(container);
            this.nameText = this.createNonEditableStyledText(container);
            this.descriptionText = new StyledText(container, 584);
            this.descriptionText.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.descriptionText);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(container.getClientArea().x, -1).applyTo((Control)this.descriptionText);
            return container;
        }

        public void onVisible(IObservableValue parameterObservable, DataBindingContext dbc) {
            Object value = parameterObservable.getValue();
            if (!(value instanceof IParameter) || DisposeUtils.isDisposed((Control)this.nameText)) {
                return;
            }
            IParameter parameter = (IParameter)value;
            String name = parameter.getName();
            this.nameText.setText(name);
            this.nameText.setStyleRange(StyledTextUtils.createBoldStyle((String)name, null));
            this.descriptionText.setText(parameter.getDescription());
        }

        public boolean isViewFor(Object object) {
            return object instanceof IParameter;
        }
    }
}

