/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate;

import com.openshift.restclient.model.template.IParameter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerCellDecorationManager;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.EditValueDialog;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.ApplicationSourceFromTemplateModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.ITemplateParametersPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateParameterDetailViews;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromtemplate.TemplateParameterViewerUtils;

public class TemplateParametersPage
extends AbstractOpenShiftWizardPage {
    public static final String PAGE_NAME = "Template Parameter Page";
    private ITemplateParametersPageModel model;
    private TableViewer viewer;
    private static final String CELL_NOT_PARAMETER_ERROR = "cell element is not a IParameter";
    GitSourceValidator gitSourceValidator = new GitSourceValidator();

    public TemplateParametersPage(IWizard wizard, ITemplateParametersPageModel model) {
        super("Template Parameters", "Edit the parameter values to be substituted into the template.", PAGE_NAME, wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Composite tableContainer = new Composite(container, 0);
        IObservableList parametersObservable = BeanProperties.list((String)"parameters").observe((Object)this.model);
        this.viewer = this.createTable(tableContainer, (IObservableList<IParameter>)parametersObservable, dbc);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).hint(500, 300).applyTo((Control)tableContainer);
        this.viewer.setInput((Object)parametersObservable);
        IObservableValue selectedParameter = BeanProperties.value((String)"selectedParameter").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(selectedParameter).in(dbc);
        this.viewer.addDoubleClickListener(this.onDoubleClick());
        Button editExistingButton = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)editExistingButton);
        editExistingButton.setText("Edit...");
        UIUtils.setDefaultButtonWidth((Button)editExistingButton);
        editExistingButton.addSelectionListener(this.onEdit());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(selectedParameter).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button resetButton = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)resetButton);
        resetButton.setText("Reset");
        UIUtils.setDefaultButtonWidth((Button)resetButton);
        resetButton.addSelectionListener(this.onReset());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)resetButton)).notUpdatingParticipant()).to(selectedParameter).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                if (fromObject instanceof IParameter && ((ApplicationSourceFromTemplateModel)TemplateParametersPage.this.model).isParameterModified((IParameter)fromObject)) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        Button resetAllButton = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)resetAllButton);
        resetAllButton.setText("Reset All");
        UIUtils.setDefaultButtonWidth((Button)resetAllButton);
        resetAllButton.addSelectionListener(this.onResetAll());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)resetAllButton)).notUpdatingParticipant()).to(selectedParameter).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                return TemplateParametersPage.this.model.getParameters().stream().anyMatch(p -> ((ApplicationSourceFromTemplateModel)TemplateParametersPage.this.model).isParameterModified((IParameter)p));
            }
        })).in(dbc);
        Label requiredExplanationLabel = new Label(container, 0);
        requiredExplanationLabel.setText("* = value required, click the 'Edit...' button or double-click on a value to edit it.");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).span(2, 1).applyTo((Control)requiredExplanationLabel);
        Group detailsContainer = new Group(container, 0);
        detailsContainer.setText("Details");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).hint(-1, 106).applyTo((Control)detailsContainer);
        new TemplateParameterDetailViews(selectedParameter, (Composite)detailsContainer, dbc).createControls();
        ((ApplicationSourceFromTemplateModel)this.model).addPropertyChangeListener(evt -> {
            if ("modifiedParameter".equals(evt.getPropertyName())) {
                this.viewer.refresh(evt.getNewValue());
            }
        });
    }

    private IListChangeListener<IParameter> onParametersChanged(TableViewerCellDecorationManager cellDecorations, ObservableMap<String, IStatus> validationStatusByParameter) {
        return event -> {
            validationStatusByParameter.clear();
            cellDecorations.hideAll();
        };
    }

    private IDoubleClickListener onDoubleClick() {
        return event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            IParameter param = (IParameter)selection.getFirstElement();
            this.openEditDialog(param);
        };
    }

    public TableViewer createTable(Composite tableContainer, IObservableList<IParameter> parametersObservable, DataBindingContext dbc) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        WritableMap cellsValidationStatusObservable = new WritableMap(String.class, IStatus.class);
        TableViewerCellDecorationManager decorations = new TableViewerCellDecorationManager(decorationImage, table);
        DataBindingUtils.addDisposableListChangeListener(this.onParametersChanged(decorations, (ObservableMap<String, IStatus>)cellsValidationStatusObservable), parametersObservable, (Control)table);
        TableViewer tableViewer = this.buildTableViewer(table, tableContainer, (ObservableMap<String, IStatus>)cellsValidationStatusObservable, decorations);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator((ObservableMap)cellsValidationStatusObservable){
            private final /* synthetic */ ObservableMap val$cellsValidationStatusObservable;
            {
                this.val$cellsValidationStatusObservable = observableMap;
            }

            protected IStatus validate() {
                for (IStatus cellValidationStatus : this.val$cellsValidationStatusObservable.values()) {
                    if (cellValidationStatus == null || cellValidationStatus.isOK()) continue;
                    return cellValidationStatus;
                }
                return ValidationStatus.ok();
            }
        });
        return tableViewer;
    }

    private TableViewer buildTableViewer(Table table, Composite tableContainer, final ObservableMap<String, IStatus> cellsValidationStatusObservable, final TableViewerCellDecorationManager decorations) {
        final TableViewerBuilder builder = new TableViewerBuilder(table, tableContainer);
        TableViewer tableViewer = builder.contentProvider((IStructuredContentProvider)new ObservableListContentProvider()).column(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Assert.isLegal((boolean)(cell.getElement() instanceof IParameter), (String)TemplateParametersPage.CELL_NOT_PARAMETER_ERROR);
                IParameter parameter = (IParameter)cell.getElement();
                String label = parameter.getName();
                if (parameter.isRequired()) {
                    label = this.markRequired(label);
                }
                cell.setText(label);
            }

            private String markRequired(String label) {
                label = String.valueOf(label) + " *";
                return label;
            }

            public String getToolTipText(Object object) {
                Assert.isLegal((boolean)(object instanceof IParameter), (String)TemplateParametersPage.CELL_NOT_PARAMETER_ERROR);
                return ((IParameter)object).getDescription();
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 0;
            }
        }).name("Name").align(16384).weight(1).minWidth(180).buildColumn().column(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Assert.isLegal((boolean)(cell.getElement() instanceof IParameter), (String)TemplateParametersPage.CELL_NOT_PARAMETER_ERROR);
                IParameter parameter = (IParameter)cell.getElement();
                String label = TemplateParameterViewerUtils.getValueLabel(parameter);
                cell.setText(label);
                boolean italic = ((ApplicationSourceFromTemplateModel)TemplateParametersPage.this.model).isParameterModified(parameter);
                builder.applyFont(cell, italic);
                IStatus validationStatus = this.validate(parameter);
                cellsValidationStatusObservable.put((Object)parameter.getName(), (Object)validationStatus);
                decorations.toggle(!validationStatus.isOK(), cell);
            }

            private IStatus validate(IParameter parameter) {
                if (parameter.isRequired() && StringUtils.isEmpty((String)parameter.getValue()) && StringUtils.isEmpty((String)parameter.getGeneratorName())) {
                    return ValidationStatus.error((String)NLS.bind((String)"Parameter {0} is required, please provide a value.", (Object)parameter.getName()));
                }
                IStatus status = TemplateParametersPage.this.gitSourceValidator.validate(parameter);
                if (!status.isOK()) {
                    return status;
                }
                return ValidationStatus.ok();
            }

            public String getToolTipText(Object object) {
                Assert.isLegal((boolean)(object instanceof IParameter), (String)TemplateParametersPage.CELL_NOT_PARAMETER_ERROR);
                return ((IParameter)object).getDescription();
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 0;
            }
        }).name("Value").align(16384).weight(1).buildColumn().buildViewer();
        tableViewer.setComparator((ViewerComparator)new TemplateParameterViewerUtils.ParameterNameViewerComparator());
        return tableViewer;
    }

    private static boolean isGitSourceParameterName(String name) {
        return "SOURCE_REPOSITORY_URL".equals(name) || "GIT_URI".equals(name);
    }

    private SelectionListener onEdit() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateParametersPage.this.openEditDialog(TemplateParametersPage.this.getSelectedParameter());
            }
        };
    }

    private void openEditDialog(IParameter parameter) {
        EditValueDialog dialog = new EditValueDialog(this.getShell(), "Edit Template Parameter", NLS.bind((String)"Please enter a value for {0}.\n{1}", (Object)parameter.getName(), (Object)parameter.getDescription()), parameter.getName(), parameter.getValue(), parameter.isRequired());
        if (TemplateParametersPage.isGitSourceParameterName(parameter.getName())) {
            GitSourceValidator valueValidator = new GitSourceValidator();
            valueValidator.setParameter(parameter);
            dialog.setValueValidator(valueValidator);
        }
        if (dialog.open() == 0) {
            this.model.updateParameterValue(parameter, dialog.getValue());
        }
    }

    private SelectionListener onReset() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateParametersPage.this.model.resetParameter(TemplateParametersPage.this.getSelectedParameter());
            }
        };
    }

    private SelectionListener onResetAll() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateParametersPage.this.model.getParameters().stream().forEach(p -> TemplateParametersPage.this.model.resetParameter((IParameter)p));
            }
        };
    }

    private IParameter getSelectedParameter() {
        return (IParameter)this.viewer.getStructuredSelection().getFirstElement();
    }

    class GitSourceValidator
    implements IValidator {
        private IParameter parameter;

        GitSourceValidator() {
        }

        public void setParameter(IParameter parameter) {
            this.parameter = parameter;
        }

        public IStatus validate(Object value) {
            String message;
            IParameter parameter = null;
            String paramaterValue = null;
            if (value instanceof IParameter) {
                parameter = (IParameter)value;
                paramaterValue = parameter.getValue();
            } else if (value instanceof String) {
                parameter = this.parameter;
                paramaterValue = (String)value;
            }
            if (parameter != null && !StringUtils.isEmpty((String)paramaterValue) && (message = this.validateGitSource(parameter.getName(), paramaterValue)) != null) {
                if (parameter.isRequired()) {
                    return ValidationStatus.error((String)message);
                }
                return ValidationStatus.warning((String)message);
            }
            return ValidationStatus.ok();
        }

        private String validateGitSource(String name, String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            if (TemplateParametersPage.isGitSourceParameterName(name)) {
                if (!UrlUtils.isValid((String)value)) {
                    return NLS.bind((String)"Parameter {0} is not a valid URL.", (Object)name);
                }
                if (!value.startsWith("http://") && !value.startsWith("https://")) {
                    return NLS.bind((String)"Parameter {0} should be an http(s) connection.", (Object)name);
                }
            }
            return null;
        }
    }
}

