/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.project;

import com.openshift.restclient.model.IProject;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.connection.Connection;

public class ManageProjectsWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_PROJECT = "selectedProject";
    public static final String PROPERTY_PROJECTS = "projects";
    private Connection connection;
    private IProject selectedProject;
    private List<IProject> projects;
    private IConnectionsRegistryListener connectionChangeListener;

    public ManageProjectsWizardPageModel(IProject project, Connection connection) {
        this(connection);
        this.setSelectedProject(project);
    }

    public ManageProjectsWizardPageModel(Connection connection) {
        this.connection = connection;
        this.connectionChangeListener = this.onConnectionsChanged();
        ConnectionsRegistrySingleton.getInstance().addListener(this.connectionChangeListener);
    }

    private IConnectionsRegistryListener onConnectionsChanged() {
        return new IConnectionsRegistryListener(){

            public void connectionRemoved(IConnection connection) {
                if (connection != null && connection.equals(ManageProjectsWizardPageModel.this.connection)) {
                    ManageProjectsWizardPageModel.this.connection = null;
                    ManageProjectsWizardPageModel.this.setProjects(Collections.emptyList());
                }
            }

            public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
                if (connection != null && connection.equals(ManageProjectsWizardPageModel.this.connection) && "openshift.projects".equals(property)) {
                    ManageProjectsWizardPageModel.this.setProjects((List)newValue);
                }
            }

            public void connectionAdded(IConnection connection) {
                if (connection != null && connection.equals(ManageProjectsWizardPageModel.this.connection)) {
                    ManageProjectsWizardPageModel.this.connection = (Connection)connection;
                    ManageProjectsWizardPageModel.this.loadProjects();
                }
            }
        };
    }

    public void loadProjects() {
        if (this.connection == null) {
            this.setProjects(Collections.emptyList());
        } else {
            List projects = this.connection.getResources("Project");
            this.setProjects(projects);
        }
    }

    public void setProjects(List<IProject> projects) {
        this.projects = projects;
        this.firePropertyChange(PROPERTY_PROJECTS, null, this.projects);
    }

    public List<IProject> getProjects() {
        return this.projects;
    }

    public void refresh() {
        this.connection.refresh();
        this.loadProjects();
    }

    public void setSelectedProject(IProject project) {
        this.selectedProject = project;
        this.firePropertyChange(PROPERTY_SELECTED_PROJECT, this.selectedProject, this.selectedProject);
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void dispose() {
        ConnectionsRegistrySingleton.getInstance().removeListener(this.connectionChangeListener);
    }
}

