/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.resource;

import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.util.KeyValueFilterFactory;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;
import org.jboss.tools.openshift.internal.ui.job.OpenShiftJobs;

public class DeleteResourcesWizardModel
extends ObservablePojo {
    private static final String[] ALL_RESOURCE_KINDS = new String[]{"Build", "BuildConfig", "DeploymentConfig", "ImageStream", "Route", "Template", "Pod", "PersistentVolumeClaim", "PersistentVolume", "ReplicationController", "Service", "Secret", "ConfigMap"};
    public static final String PROP_LABEL_FILTER = "labelFilter";
    public static final String PROP_ALL_RESOURCES = "allResources";
    public static final String PROP_SELECTED_RESOURCES = "selectedResources";
    private Connection connection;
    private String namespace;
    private KeyValueFilterFactory.KeyValueFilter labelFilter;
    private List<IResource> allResources = new ArrayList<IResource>();
    private List<IResource> selectedResources = new ArrayList<IResource>();

    public DeleteResourcesWizardModel(Connection connection, String namespace) {
        this.connection = connection;
        this.namespace = namespace;
    }

    public void setLabelFilter(KeyValueFilterFactory.KeyValueFilter filter) {
        this.labelFilter = filter;
        this.firePropertyChange(PROP_LABEL_FILTER, this.labelFilter, this.labelFilter);
    }

    public KeyValueFilterFactory.KeyValueFilter getLabelFilter() {
        return this.labelFilter;
    }

    public void loadResources(IProgressMonitor monitor) {
        if (this.connection == null || StringUtils.isEmpty((String)this.namespace)) {
            return;
        }
        this.setAllResources(this.loadAllResources(monitor));
    }

    private List<IResource> loadAllResources(IProgressMonitor monitor) {
        return Arrays.stream(ALL_RESOURCE_KINDS).flatMap(resourceKind -> this.safeLoadResources((String)resourceKind, this.namespace, this.connection, monitor).stream()).collect(Collectors.toList());
    }

    private Collection<IResource> safeLoadResources(String resourceKind, String namespace, Connection connection, IProgressMonitor monitor) {
        try {
            monitor.subTask(NLS.bind((String)"Loading all {0} resources...", (Object)resourceKind));
            return connection.getResources(resourceKind, namespace);
        }
        catch (NotFoundException | ResourceForbiddenException throwable) {
            return Collections.emptyList();
        }
    }

    private void setAllResources(List<IResource> allResources) {
        ArrayList<IResource> old = new ArrayList<IResource>(this.allResources);
        this.allResources.clear();
        this.allResources.addAll(allResources);
        this.firePropertyChange(PROP_ALL_RESOURCES, old, allResources);
        this.setSelectedResources(Collections.emptyList());
    }

    public List<IResource> getSelectedResources() {
        return this.selectedResources;
    }

    public void setSelectedResources(List<IResource> allResources) {
        ArrayList<IResource> old = new ArrayList<IResource>(this.selectedResources);
        this.selectedResources.clear();
        this.selectedResources.addAll(allResources);
        this.firePropertyChange(PROP_SELECTED_RESOURCES, old, allResources);
    }

    public List<IResource> getAllResources() {
        return this.allResources;
    }

    public void deleteSelectedResources() {
        this.deleteResources(new ArrayList<IResource>(this.selectedResources));
    }

    protected void deleteResources(List<IResource> resources) {
        if (CollectionUtils.isEmpty(resources)) {
            return;
        }
        JobGroup group = new JobGroup("Deleting OpenShift resources...", 1, resources.size()){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return false;
            }
        };
        List<IResource> toBeDeleted = this.removeImplicitRemovals(resources);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = toBeDeleted.stream();){
            stream.forEach(resource -> {
                DeleteResourceJob job = OpenShiftJobs.createDeleteResourceJob(resource);
                job.setJobGroup(group);
                job.schedule();
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<IResource> removeImplicitRemovals(List<IResource> resources) {
        return resources.stream().filter(resource -> !"Pod".equals(resource.getKind()) || !ResourceUtils.hasRelatedPods((IPod)((IPod)resource), (List)resources)).filter(resource -> !"ReplicationController".equals(resource.getKind()) || !ResourceUtils.hasRelatedDc((IReplicationController)((IReplicationController)resource), (List)resources)).collect(Collectors.toList());
    }
}

