/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.cheatsheet;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.project.examples.cheatsheet.internal.util.CheatSheetUtil;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final String DOT_CHEATSHEET_XML = ".cheatsheet.xml";
    private static final String CHEATSHEET_XML = "cheatsheet.xml";
    public static final String PLUGIN_ID = "org.jboss.tools.project.examples.cheatsheet";
    private static Activator plugin;
    IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            String value = ProjectExamplesActivator.getDefault().getShowCheatsheets();
            if ("never".equals(value)) {
                return;
            }
            final ArrayList<IFile> cheatsheets = new ArrayList<IFile>();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta == null) {
                            return false;
                        }
                        IResource resource = delta.getResource();
                        if (resource instanceof IWorkspaceRoot) {
                            return true;
                        }
                        if (resource instanceof IProject && ((IProject)resource).isOpen()) {
                            return true;
                        }
                        if (resource instanceof IFile && delta.getKind() == 1 && Activator.isCheatcheet((IFile)resource)) {
                            cheatsheets.add((IFile)resource);
                            return false;
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            if (cheatsheets.size() > 0) {
                CheatSheetUtil.showCheatsheet(cheatsheets);
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        super.stop(context);
    }

    public static boolean isCheatcheet(IFile file) {
        boolean candidate;
        String fileName = file.getName().toLowerCase();
        boolean bl = candidate = CHEATSHEET_XML.equals(fileName) || DOT_CHEATSHEET_XML.equals(fileName);
        if (candidate) {
            IContentDescription contentDescription;
            block4: {
                contentDescription = file.getContentDescription();
                if (contentDescription != null) break block4;
                return false;
            }
            try {
                IContentType contentType = contentDescription.getContentType();
                return contentType != null && "org.eclipse.pde.simpleCheatSheet".equals(contentType.getId());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        plugin.getLog().log((IStatus)status);
    }

    public static void showCheatsheet(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object object = structuredSelection.getFirstElement();
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                CheatSheetUtil.showCheatsheet(file);
            } else if (object instanceof IAdaptable) {
                IProject project = (IProject)((IAdaptable)object).getAdapter(IProject.class);
                if (project == null) {
                    return;
                }
                final ArrayList cheatsheets = new ArrayList();
                try {
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IProject) {
                                return true;
                            }
                            if (resource instanceof IFile) {
                                IFile file = (IFile)resource;
                                if (Activator.isCheatcheet(file)) {
                                    cheatsheets.add(file);
                                }
                                return false;
                            }
                            return false;
                        }
                    });
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                if (cheatsheets.size() > 0) {
                    CheatSheetUtil.showCheatsheet((IFile)cheatsheets.get(0));
                }
            }
        }
    }
}

