/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.cheatsheet.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.IImportProjectExample;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class ImportProjectExample
extends Action
implements ICheatSheetAction {
    public void run(String[] params, ICheatSheetManager manager) {
        if (params == null || params[0] == null || params[1] == null || params[2] == null) {
            return;
        }
        ProjectExampleWorkingCopy project = new ProjectExampleWorkingCopy();
        project.setName(params[0]);
        StringTokenizer tokenizer = new StringTokenizer(params[1], ",");
        ArrayList<String> includedProjects = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            includedProjects.add(tokenizer.nextToken().trim());
        }
        project.setIncludedProjects(includedProjects);
        project.setUrl(params[2]);
        this.importProject(project);
    }

    private void importProject(final ProjectExampleWorkingCopy project) {
        WorkspaceJob workspaceJob = new WorkspaceJob(Messages.NewProjectExamplesWizard_Downloading){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ProjectExamplesActivator.downloadProject((ProjectExample)project, (IProgressMonitor)monitor);
                this.setName(Messages.NewProjectExamplesWizard_Importing);
                try {
                    IImportProjectExample importProjectExample = ProjectExamplesActivator.getDefault().getImportProjectExample(project.getImportType());
                    if (importProjectExample.importProject(project, project.getFile(), new HashMap(), monitor)) {
                        UsageEventType createProjectEvent = ProjectExamplesActivator.getDefault().getCreateProjectFromExampleEventType();
                        UsageReporter.getInstance().trackEvent(createProjectEvent.event(project.getId()));
                        importProjectExample.fix(project, monitor);
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.jboss.tools.project.examples.cheatsheet", e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setUser(true);
        workspaceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                try {
                    ProjectExamplesActivator.waitForBuildAndValidation.schedule();
                    ProjectExamplesActivator.waitForBuildAndValidation.join();
                }
                catch (InterruptedException e) {
                    return;
                }
                ProjectExamplesActivator.showReadyWizard(Collections.singletonList(project));
            }
        });
        workspaceJob.schedule();
    }
}

