/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.cheatsheet.internal.commands;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.jboss.tools.project.examples.cheatsheet.Activator;

public class CheatSheetPropertyTester
extends PropertyTester {
    private static final String IS_CHEATSHEET = "isCheatSheet";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!IS_CHEATSHEET.equals(property)) {
            return false;
        }
        IResource resource = (IResource)receiver;
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            if (!project.isOpen()) {
                return false;
            }
            final boolean[] result = new boolean[]{false};
            try {
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IProject) {
                            return true;
                        }
                        if (resource instanceof IFile && Activator.isCheatcheet((IFile)resource)) {
                            result[0] = true;
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            return result[0];
        }
        if (resource instanceof IFile) {
            IContentDescription contentDescription;
            block9: {
                IFile file = (IFile)resource;
                contentDescription = file.getContentDescription();
                if (contentDescription != null) break block9;
                return false;
            }
            try {
                IContentType contentType = contentDescription.getContentType();
                return contentType != null && "org.eclipse.pde.simpleCheatSheet".equals(contentType.getId());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

