/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.project.examples.FavoriteItem;
import org.jboss.tools.project.examples.IFavoriteExampleManager;
import org.jboss.tools.project.examples.internal.FavoriteItemXmlSerializer;
import org.jboss.tools.project.examples.internal.IFavoriteSerializer;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;

public class FavoriteExampleManager
implements IFavoriteExampleManager {
    private IFavoriteSerializer favoriteSerializer;

    public FavoriteExampleManager() {
        this(null);
    }

    public FavoriteExampleManager(IFavoriteSerializer favoriteSerializer) {
        if (favoriteSerializer == null) {
            File baseDir = ProjectExamplesActivator.getDefault().getStateLocation().toFile();
            File xmlFile = new File(baseDir, "favorites.xml");
            favoriteSerializer = new FavoriteItemXmlSerializer(xmlFile);
        }
        this.favoriteSerializer = favoriteSerializer;
    }

    @Override
    public void favorite(String itemId, IProgressMonitor monitor) throws CoreException {
        Map<String, FavoriteItem> favoritesMap = this.getFavoriteItems(monitor);
        FavoriteItem item = this.getFavoriteItem(itemId, favoritesMap, monitor);
        item.setCount(item.getCount() + 1);
        item.setLastTimeUsed(System.currentTimeMillis());
        favoritesMap.put(itemId, item);
        this.favoriteSerializer.serialize(favoritesMap.values());
    }

    @Override
    public List<FavoriteItem> getFavoriteItems(int maxFavorites, IProgressMonitor monitor) throws CoreException {
        Map<String, FavoriteItem> favoriteItemsMap = this.getFavoriteItems(monitor);
        ArrayList<FavoriteItem> favorites = new ArrayList<FavoriteItem>(favoriteItemsMap.values());
        Collections.sort(favorites);
        if (maxFavorites >= favorites.size()) {
            return favorites;
        }
        return favorites.subList(0, maxFavorites);
    }

    protected FavoriteItem getFavoriteItem(String id, Map<String, FavoriteItem> favoritesMap, IProgressMonitor monitor) {
        FavoriteItem item = favoritesMap.get(id);
        if (item == null) {
            item = new FavoriteItem();
            item.setId(id);
        }
        return item;
    }

    Map<String, FavoriteItem> getFavoriteItems(IProgressMonitor monitor) throws CoreException {
        Collection<FavoriteItem> favorites = this.favoriteSerializer.deSerialize();
        HashMap<String, FavoriteItem> favoritesMap = new HashMap<String, FavoriteItem>(favorites.size());
        for (FavoriteItem fi : favorites) {
            favoritesMap.put(fi.getId(), fi);
        }
        return favoritesMap;
    }
}

